/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.openapi;

import com.networknt.openapi.NormalisedPath;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiNormalisedPath
implements NormalisedPath {
    Logger logger = LoggerFactory.getLogger(ApiNormalisedPath.class);
    private final List<String> pathParts;
    private final String original;
    private final String normalised;

    public ApiNormalisedPath(String path, String basePath) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("path = {}, base path is set to: {}", (Object)path, (Object)basePath);
        }
        this.original = Objects.requireNonNull(path, "A path is required");
        this.normalised = this.normalise(path, basePath);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("normalised = " + this.normalised);
        }
        this.pathParts = List.of(this.normalised.split("/"));
    }

    @Override
    public List<String> parts() {
        return this.pathParts;
    }

    @Override
    public String part(int index) {
        return this.pathParts.get(index);
    }

    @Override
    public boolean isParam(int index) {
        String part = this.part(index);
        return part.startsWith("{") && part.endsWith("}");
    }

    @Override
    public String paramName(int index) {
        if (!this.isParam(index)) {
            return null;
        }
        String part = this.part(index);
        return part.substring(1, part.length() - 1);
    }

    @Override
    public String original() {
        return this.original;
    }

    @Override
    public String normalised() {
        return this.normalised;
    }

    private String normalise(String requestPath, String basePath) {
        if (!(requestPath = requestPath.replaceFirst(basePath, "")).startsWith("/")) {
            return "/" + requestPath;
        }
        return requestPath;
    }
}

