/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.client.configuration;

import com.openshift.client.configuration.IOpenShiftConfiguration;
import com.openshift.internal.client.utils.StreamUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractOpenshiftConfiguration
implements IOpenShiftConfiguration {
    public static final String SCHEME_HTTPS = "https://";
    protected static final String KEY_RHLOGIN = "default_rhlogin";
    protected static final String KEY_LIBRA_SERVER = "libra_server";
    protected static final String KEY_LIBRA_DOMAIN = "libra_domain";
    protected static final String KEY_PASSWORD = "rhpassword";
    protected static final String KEY_CLIENT_ID = "client_id";
    private static final Pattern SINGLEQUOTED_REGEX = Pattern.compile("'*([^']+)'*");
    private static final char SINGLEQUOTE = '\'';
    private static final String SYSPROPERTY_PROXY_PORT = "proxyPort";
    private static final String SYSPROPERTY_PROXY_HOST = "proxyHost";
    private static final String SYSPROPERTY_PROXY_SET = "proxySet";
    private Properties properties;
    private File file;
    private boolean doSSLChecks = false;

    protected AbstractOpenshiftConfiguration() throws FileNotFoundException, IOException {
        this(null, null);
    }

    protected AbstractOpenshiftConfiguration(IOpenShiftConfiguration parentConfiguration) throws FileNotFoundException, IOException {
        this(null, parentConfiguration);
    }

    protected AbstractOpenshiftConfiguration(File file, IOpenShiftConfiguration parentConfiguration) throws FileNotFoundException, IOException {
        this.initProperties(file, parentConfiguration == null ? null : parentConfiguration.getProperties());
    }

    protected void initProperties(File file) throws FileNotFoundException, IOException {
        this.initProperties(file, null);
    }

    protected void initProperties(Properties defaultProperties) throws FileNotFoundException, IOException {
        this.initProperties(null, defaultProperties);
    }

    protected void initProperties(File file, Properties defaultProperties) throws FileNotFoundException, IOException {
        this.file = file;
        this.properties = this.getProperties(file, defaultProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties getProperties(File file, Properties defaultProperties) throws FileNotFoundException, IOException {
        Properties properties;
        if (file == null || !file.canRead()) {
            return new Properties(defaultProperties);
        }
        FileReader reader = null;
        try {
            Properties properties2 = new Properties(defaultProperties);
            reader = new FileReader(file);
            properties2.load(reader);
            properties = properties2;
        }
        catch (Throwable throwable) {
            StreamUtils.close(reader);
            throw throwable;
        }
        StreamUtils.close(reader);
        return properties;
    }

    protected File getFile() {
        return this.file;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        if (this.file == null) {
            return;
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(this.file);
            this.properties.store(writer, "");
        }
        catch (Throwable throwable) {
            StreamUtils.close(writer);
            throw throwable;
        }
        StreamUtils.close(writer);
    }

    @Override
    public void setRhlogin(String rhlogin) {
        this.properties.put(KEY_RHLOGIN, rhlogin);
    }

    @Override
    public String getRhlogin() {
        return this.properties.getProperty(KEY_RHLOGIN);
    }

    @Override
    public void setLibraServer(String libraServer) {
        this.properties.put(KEY_LIBRA_SERVER, this.ensureIsSingleQuoted(libraServer));
    }

    @Override
    public String getLibraServer() {
        return this.appendScheme(this.removeSingleQuotes(this.properties.getProperty(KEY_LIBRA_SERVER)));
    }

    @Override
    public void setLibraDomain(String libraDomain) {
        this.properties.put(KEY_LIBRA_DOMAIN, this.ensureIsSingleQuoted(libraDomain));
    }

    @Override
    public String getLibraDomain() {
        return this.removeSingleQuotes(this.properties.getProperty(KEY_LIBRA_DOMAIN));
    }

    protected String appendScheme(String host) {
        if (host == null) {
            return host;
        }
        return SCHEME_HTTPS + host;
    }

    protected String ensureIsSingleQuoted(String value) {
        return '\'' + this.removeSingleQuotes(value) + '\'';
    }

    protected String removeSingleQuotes(String value) {
        if (value == null) {
            return null;
        }
        Matcher matcher = SINGLEQUOTED_REGEX.matcher(value);
        if (matcher.find() && matcher.groupCount() == 1) {
            return matcher.group(1);
        }
        return value;
    }

    public String getPassword() {
        return this.properties.getProperty(KEY_PASSWORD);
    }

    public String getClientId() {
        return this.properties.getProperty(KEY_CLIENT_ID);
    }

    public void setEnableSSLCertChecks(boolean doSSLChecks) {
        this.doSSLChecks = doSSLChecks;
    }

    public void setProxySet(boolean proxySet) {
        if (proxySet) {
            System.setProperty(SYSPROPERTY_PROXY_SET, "true");
        } else {
            System.setProperty(SYSPROPERTY_PROXY_SET, "false");
        }
    }

    public void setProxyHost(String proxyHost) {
        System.setProperty(SYSPROPERTY_PROXY_HOST, proxyHost);
    }

    public void setProxyPort(String proxyPort) {
        System.setProperty(SYSPROPERTY_PROXY_PORT, proxyPort);
    }
}

