/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.openshift.client.ApplicationScale;
import com.openshift.client.IApplication;
import com.openshift.client.IApplicationPortForwarding;
import com.openshift.client.IDomain;
import com.openshift.client.IGearGroup;
import com.openshift.client.IGearProfile;
import com.openshift.client.IOpenShiftConnection;
import com.openshift.client.Messages;
import com.openshift.client.OpenShiftException;
import com.openshift.client.OpenShiftSSHOperationException;
import com.openshift.client.cartridge.IEmbeddableCartridge;
import com.openshift.client.cartridge.IEmbeddedCartridge;
import com.openshift.client.cartridge.IStandaloneCartridge;
import com.openshift.client.cartridge.StandaloneCartridge;
import com.openshift.client.utils.HostUtils;
import com.openshift.client.utils.RFC822DateUtils;
import com.openshift.internal.client.AbstractOpenShiftResource;
import com.openshift.internal.client.DomainResource;
import com.openshift.internal.client.EmbeddedCartridgeResource;
import com.openshift.internal.client.GearGroupResource;
import com.openshift.internal.client.httpclient.request.Parameter;
import com.openshift.internal.client.httpclient.request.StringParameter;
import com.openshift.internal.client.response.ApplicationResourceDTO;
import com.openshift.internal.client.response.CartridgeResourceDTO;
import com.openshift.internal.client.response.GearGroupResourceDTO;
import com.openshift.internal.client.response.Link;
import com.openshift.internal.client.ssh.ApplicationPortForwarding;
import com.openshift.internal.client.utils.Assert;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationResource
extends AbstractOpenShiftResource
implements IApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationResource.class);
    private static final long APPLICATION_WAIT_RETRY_DELAY = 2048L;
    private static final String LINK_DELETE_APPLICATION = "DELETE";
    private static final String LINK_START_APPLICATION = "START";
    private static final String LINK_STOP_APPLICATION = "STOP";
    private static final String LINK_FORCE_STOP_APPLICATION = "FORCE_STOP";
    private static final String LINK_RESTART_APPLICATION = "RESTART";
    private static final String LINK_SCALE_UP = "SCALE_UP";
    private static final String LINK_SCALE_DOWN = "SCALE_DOWN";
    private static final String LINK_ADD_ALIAS = "ADD_ALIAS";
    private static final String LINK_REMOVE_ALIAS = "REMOVE_ALIAS";
    private static final String LINK_ADD_CARTRIDGE = "ADD_CARTRIDGE";
    private static final String LINK_LIST_CARTRIDGES = "LIST_CARTRIDGES";
    private static final String LINK_GET_GEAR_GROUPS = "GET_GEAR_GROUPS";
    private static final Pattern REGEX_FORWARDED_PORT = Pattern.compile("([^ ]+) -> ([^:]+):(\\d+)");
    private final String uuid;
    private final String name;
    private final Date creationTime;
    private IStandaloneCartridge cartridge;
    private final ApplicationScale scale;
    private final IGearProfile gearProfile;
    private final DomainResource domain;
    private final String applicationUrl;
    private final String gitUrl;
    private final String initialGitUrl;
    private final List<String> aliases;
    private Map<String, EmbeddedCartridgeResource> embeddedCartridgesByName = new LinkedHashMap<String, EmbeddedCartridgeResource>();
    private List<IApplicationPortForwarding> ports = null;
    private Session session;
    private Collection<IGearGroup> gearGroups;

    protected ApplicationResource(ApplicationResourceDTO dto, DomainResource domain) {
        this(dto.getName(), dto.getUuid(), dto.getCreationTime(), dto.getMessages(), dto.getApplicationUrl(), dto.getGitUrl(), dto.getInitialGitUrl(), dto.getGearProfile(), dto.getApplicationScale(), dto.getAliases(), dto.getCartridges(), dto.getLinks(), domain);
    }

    protected ApplicationResource(String name, String uuid, String creationTime, Messages messages, String applicationUrl, String gitUrl, String initialGitUrl, IGearProfile gearProfile, ApplicationScale scale, List<String> aliases, Map<String, CartridgeResourceDTO> cartridgesByName, Map<String, Link> links, DomainResource domain) {
        super(domain.getService(), links, messages);
        this.name = name;
        this.uuid = uuid;
        this.creationTime = RFC822DateUtils.safeGetDate(creationTime);
        this.scale = scale;
        this.gearProfile = gearProfile;
        this.applicationUrl = applicationUrl;
        this.gitUrl = gitUrl;
        this.initialGitUrl = initialGitUrl;
        this.domain = domain;
        this.aliases = aliases;
        this.updateCartridges(cartridgesByName);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ApplicationScale getApplicationScale() {
        return this.scale;
    }

    @Override
    public IGearProfile getGearProfile() {
        return this.gearProfile;
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    @Override
    public IStandaloneCartridge getCartridge() {
        return this.cartridge;
    }

    @Override
    public Date getCreationTime() {
        return this.creationTime;
    }

    @Override
    public IDomain getDomain() {
        return this.domain;
    }

    @Override
    public void destroy() throws OpenShiftException {
        new DeleteApplicationRequest().execute(new Parameter[0]);
        this.domain.removeApplication(this);
    }

    @Override
    public void start() throws OpenShiftException {
        new StartApplicationRequest().execute();
    }

    @Override
    public void restart() throws OpenShiftException {
        new RestartApplicationRequest().execute();
    }

    @Override
    public void stop() throws OpenShiftException {
        this.stop(false);
    }

    @Override
    public void stop(boolean force) throws OpenShiftException {
        if (force) {
            new ForceStopApplicationRequest().execute();
        } else {
            new StopApplicationRequest().execute();
        }
    }

    public void getDescriptor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void scaleDown() throws OpenShiftException {
        new ScaleDownRequest().execute();
    }

    @Override
    public void scaleUp() throws OpenShiftException {
        new ScaleUpRequest().execute();
    }

    @Override
    public void addAlias(String alias) throws OpenShiftException {
        Assert.notNull(alias);
        ApplicationResourceDTO applicationDTO = (ApplicationResourceDTO)new AddAliasRequest().execute(alias);
        this.updateAliases(applicationDTO);
    }

    private void updateAliases(ApplicationResourceDTO applicationDTO) {
        Assert.notNull(applicationDTO);
        this.aliases.clear();
        this.aliases.addAll(applicationDTO.getAliases());
    }

    @Override
    public List<String> getAliases() {
        return Collections.unmodifiableList(this.aliases);
    }

    @Override
    public boolean hasAlias(String name) {
        Assert.notNull(name);
        return this.aliases.contains(name);
    }

    @Override
    public void removeAlias(String alias) throws OpenShiftException {
        Assert.notNull(alias);
        ApplicationResourceDTO applicationDTO = (ApplicationResourceDTO)new RemoveAliasRequest().execute(alias);
        this.updateAliases(applicationDTO);
    }

    @Override
    public String getGitUrl() {
        return this.gitUrl;
    }

    @Override
    public String getInitialGitUrl() {
        return this.initialGitUrl;
    }

    @Override
    public String getApplicationUrl() {
        return this.applicationUrl;
    }

    @Override
    public IEmbeddedCartridge addEmbeddableCartridge(IEmbeddableCartridge cartridge) throws OpenShiftException {
        Assert.notNull(cartridge);
        CartridgeResourceDTO embeddedCartridgeDTO = (CartridgeResourceDTO)new AddEmbeddedCartridgeRequest().execute(cartridge);
        EmbeddedCartridgeResource embeddedCartridge = new EmbeddedCartridgeResource(embeddedCartridgeDTO, this);
        this.embeddedCartridgesByName.put(embeddedCartridge.getName(), embeddedCartridge);
        return embeddedCartridge;
    }

    @Override
    public List<IEmbeddedCartridge> addEmbeddableCartridges(Collection<IEmbeddableCartridge> cartridges) throws OpenShiftException {
        Assert.notNull(cartridges);
        ArrayList<IEmbeddedCartridge> addedCartridge = new ArrayList<IEmbeddedCartridge>();
        for (IEmbeddableCartridge cartridge : cartridges) {
            addedCartridge.add(this.addEmbeddableCartridge(cartridge));
        }
        return addedCartridge;
    }

    protected void removeEmbeddedCartridge(IEmbeddedCartridge embeddedCartridge) throws OpenShiftException {
        Assert.notNull(embeddedCartridge);
        this.embeddedCartridgesByName.remove(embeddedCartridge.getName());
    }

    protected void refreshEmbeddedCartridges() throws OpenShiftException {
        Map<String, CartridgeResourceDTO> cartridgeDTOByName = new ListCartridgesRequest().execute();
        this.updateCartridges(cartridgeDTOByName);
        this.removeCartridges(cartridgeDTOByName);
    }

    private void updateCartridges(Map<String, CartridgeResourceDTO> cartridgeDTOByName) {
        for (CartridgeResourceDTO cartridgeDTO : cartridgeDTOByName.values()) {
            switch (cartridgeDTO.getType()) {
                case STANDALONE: {
                    this.createStandaloneCartrdige(cartridgeDTO);
                    break;
                }
                case EMBEDDED: {
                    this.addOrUpdateEmbeddedCartridge(cartridgeDTO.getName(), cartridgeDTO);
                }
            }
        }
    }

    private void createStandaloneCartrdige(CartridgeResourceDTO cartridgeDTO) {
        this.cartridge = new StandaloneCartridge(cartridgeDTO.getName(), cartridgeDTO.getUrl(), cartridgeDTO.getDisplayName(), cartridgeDTO.getDescription());
    }

    private void addOrUpdateEmbeddedCartridge(String name, CartridgeResourceDTO cartridgeDTO) {
        EmbeddedCartridgeResource embeddedCartridge = this.embeddedCartridgesByName.get(name);
        if (embeddedCartridge != null) {
            embeddedCartridge.update(cartridgeDTO);
        } else {
            this.embeddedCartridgesByName.put(name, new EmbeddedCartridgeResource(cartridgeDTO, this));
        }
    }

    private void removeCartridges(Map<String, CartridgeResourceDTO> cartridgeDTOsByName) {
        ArrayList<EmbeddedCartridgeResource> cartridges = new ArrayList<EmbeddedCartridgeResource>(this.embeddedCartridgesByName.values());
        for (EmbeddedCartridgeResource cartridge : cartridges) {
            String name = cartridge.getName();
            if (cartridgeDTOsByName.containsKey(name)) continue;
            this.embeddedCartridgesByName.remove(name);
        }
    }

    @Override
    public List<IEmbeddedCartridge> getEmbeddedCartridges() throws OpenShiftException {
        return Collections.unmodifiableList(new ArrayList<EmbeddedCartridgeResource>(this.embeddedCartridgesByName.values()));
    }

    @Override
    public boolean hasEmbeddedCartridge(String cartridgeName) throws OpenShiftException {
        Assert.notNull(cartridgeName);
        return this.getEmbeddedCartridge(cartridgeName) != null;
    }

    @Override
    public boolean hasEmbeddedCartridge(IEmbeddableCartridge cartridge) throws OpenShiftException {
        return this.getEmbeddedCartridge(cartridge) != null;
    }

    @Override
    public IEmbeddedCartridge getEmbeddedCartridge(IEmbeddableCartridge cartridge) throws OpenShiftException {
        Assert.notNull(cartridge);
        for (IEmbeddedCartridge embeddedCartridge : this.getEmbeddedCartridges()) {
            if (!cartridge.equals(embeddedCartridge)) continue;
            return embeddedCartridge;
        }
        return null;
    }

    @Override
    public IEmbeddedCartridge getEmbeddedCartridge(String cartridgeName) throws OpenShiftException {
        Assert.notNull(cartridgeName);
        for (IEmbeddedCartridge embeddedCartridge : this.getEmbeddedCartridges()) {
            if (!cartridgeName.equals(embeddedCartridge.getName())) continue;
            return embeddedCartridge;
        }
        return null;
    }

    @Override
    public void removeEmbeddedCartridge(IEmbeddableCartridge cartridge) throws OpenShiftException {
        Assert.notNull(cartridge);
        IEmbeddedCartridge embeddedCartridge = this.getEmbeddedCartridge(cartridge);
        if (embeddedCartridge != null) {
            embeddedCartridge.destroy();
        }
    }

    @Override
    public void removeEmbeddedCartridges(Collection<IEmbeddableCartridge> cartridges) throws OpenShiftException {
        Assert.notNull(cartridges);
        for (IEmbeddableCartridge cartridge : cartridges) {
            this.removeEmbeddedCartridge(cartridge);
        }
    }

    @Override
    public Collection<IGearGroup> getGearGroups() throws OpenShiftException {
        if (this.gearGroups == null) {
            this.loadGearGroups();
        }
        return this.gearGroups;
    }

    private Collection<IGearGroup> loadGearGroups() throws OpenShiftException {
        ArrayList<IGearGroup> gearGroups = new ArrayList<IGearGroup>();
        Collection dtos = (Collection)new GetGearGroupsRequest().execute(new Parameter[0]);
        for (GearGroupResourceDTO dto : dtos) {
            gearGroups.add(new GearGroupResource(dto, this.getService()));
        }
        this.gearGroups = gearGroups;
        return this.gearGroups;
    }

    @Override
    public boolean waitForAccessible(long timeout) throws OpenShiftException {
        try {
            return this.waitForResolved(timeout, System.currentTimeMillis());
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public Future<Boolean> waitForAccessibleAsync(final long timeout) throws OpenShiftException {
        IOpenShiftConnection connection = this.getConnection();
        return connection.getExecutorService().submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return ApplicationResource.this.waitForAccessible(timeout);
            }
        });
    }

    protected IOpenShiftConnection getConnection() {
        return this.getDomain().getUser().getConnection();
    }

    private boolean waitForResolved(long timeout, long startTime) throws OpenShiftException, InterruptedException {
        try {
            while (!this.canResolv(this.applicationUrl) && !this.isTimeouted(timeout, startTime)) {
                Thread.sleep(2048L);
            }
            return this.canResolv(this.applicationUrl);
        }
        catch (MalformedURLException e) {
            throw new OpenShiftException(e, "Could not wait for application {0} to become accessible, it has an invalid URL \"{1}\": {2}", this.name, this.applicationUrl, e.getMessage());
        }
    }

    protected boolean canResolv(String url) throws MalformedURLException {
        return HostUtils.canResolv(url);
    }

    private boolean isTimeouted(long timeout, long startTime) {
        return System.currentTimeMillis() >= startTime + timeout;
    }

    @Override
    public void refresh() throws OpenShiftException {
        this.refreshEmbeddedCartridges();
        if (this.gearGroups != null) {
            this.gearGroups = this.loadGearGroups();
        }
        if (this.ports != null) {
            this.ports = this.loadPorts();
        }
    }

    @Override
    public void setSSHSession(Session session) {
        this.session = session;
    }

    @Override
    public Session getSSHSession() {
        return this.session;
    }

    @Override
    public boolean hasSSHSession() {
        return this.session != null && this.session.isConnected();
    }

    @Override
    public boolean isPortFowardingStarted() throws OpenShiftSSHOperationException {
        try {
            return this.session != null && this.session.isConnected() && this.session.getPortForwardingL().length > 0;
        }
        catch (JSchException e) {
            throw new OpenShiftSSHOperationException(e, "Unable to verify if port-forwarding has been started for application \"{0}\"", this.getName());
        }
    }

    @Override
    public List<IApplicationPortForwarding> refreshForwardablePorts() throws OpenShiftSSHOperationException {
        this.ports = this.loadPorts();
        return this.ports;
    }

    @Override
    public List<IApplicationPortForwarding> getForwardablePorts() throws OpenShiftSSHOperationException {
        if (this.ports == null) {
            this.ports = this.loadPorts();
        }
        return this.ports;
    }

    @Override
    public List<String> getEnvironmentProperties() throws OpenShiftSSHOperationException {
        ArrayList<String> openshiftProps = new ArrayList<String>();
        List<String> allEnvProps = this.sshExecCmd("set", SshStreams.INPUT);
        for (String line : allEnvProps) {
            if (!line.startsWith("OPENSHIFT_") && !line.startsWith("JENKINS_")) continue;
            openshiftProps.add(line);
        }
        return openshiftProps;
    }

    private List<IApplicationPortForwarding> loadPorts() throws OpenShiftSSHOperationException {
        this.ports = new ArrayList<IApplicationPortForwarding>();
        List<String> lines = this.sshExecCmd("rhc-list-ports", SshStreams.EXT_INPUT);
        for (String line : lines) {
            ApplicationPortForwarding port = this.extractForwardablePortFrom(line);
            if (port == null) continue;
            this.ports.add(port);
        }
        return this.ports;
    }

    protected List<String> sshExecCmd(String command, SshStreams sshStream) throws OpenShiftSSHOperationException {
        Session session = this.getSSHSession();
        if (session == null) {
            throw new OpenShiftSSHOperationException("No SSH session available for application ''{0}''", this.getName());
        }
        Channel channel = null;
        BufferedReader reader = null;
        try {
            session.openChannel("exec");
            channel = session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            channel.connect();
            List<String> list = sshStream.getLines(channel);
            return list;
        }
        catch (JSchException e) {
            throw new OpenShiftSSHOperationException(e, "Failed to list forwardable ports for application \"{0}\"", this.getName());
        }
        catch (IOException e) {
            throw new OpenShiftSSHOperationException(e, "Failed to list forwardable ports for application \"{0}\"", this.getName());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LOGGER.error("Failed to close SSH error stream reader", (Throwable)e);
                }
            }
            if (channel != null && channel.isConnected()) {
                channel.disconnect();
            }
        }
    }

    private ApplicationPortForwarding extractForwardablePortFrom(String portValue) {
        Matcher matcher = REGEX_FORWARDED_PORT.matcher(portValue);
        if (!matcher.find() || matcher.groupCount() != 3) {
            return null;
        }
        try {
            String name = matcher.group(1);
            String host = matcher.group(2);
            int remotePort = Integer.parseInt(matcher.group(3));
            return new ApplicationPortForwarding(this, name, host, remotePort);
        }
        catch (NumberFormatException e) {
            throw new OpenShiftSSHOperationException(e, "Couild not determine forwarded port in application {0}", this.getName());
        }
    }

    @Override
    public List<IApplicationPortForwarding> startPortForwarding() throws OpenShiftSSHOperationException {
        if (!this.hasSSHSession()) {
            throw new OpenShiftSSHOperationException("SSH session for application \"{0}\" is closed or null. Cannot start port forwarding", this.getName());
        }
        for (IApplicationPortForwarding port : this.ports) {
            try {
                port.start(this.session);
            }
            catch (OpenShiftSSHOperationException openShiftSSHOperationException) {
                // empty catch block
            }
        }
        return this.ports;
    }

    @Override
    public List<IApplicationPortForwarding> stopPortForwarding() throws OpenShiftSSHOperationException {
        for (IApplicationPortForwarding port : this.ports) {
            try {
                port.stop(this.session);
            }
            catch (OpenShiftSSHOperationException openShiftSSHOperationException) {
                // empty catch block
            }
        }
        this.session.disconnect();
        return this.ports;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ApplicationResource other = (ApplicationResource)object;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return "ApplicationResource [uuid=" + this.uuid + ", name=" + this.name + ", creationTime=" + this.creationTime + ", cartridge=" + this.cartridge + ", scale=" + (Object)((Object)this.scale) + ", gearProfile=" + this.gearProfile + ", domain=" + this.domain + ", applicationUrl=" + this.applicationUrl + ", gitUrl=" + this.gitUrl + ", initialGitUrl=" + this.initialGitUrl + ", aliases=" + this.aliases + ", gearGroups=" + this.gearGroups + "]";
    }

    private class AddAliasRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        private AddAliasRequest() {
            super(ApplicationResource.LINK_ADD_ALIAS);
        }

        protected <DTO> DTO execute(String alias) throws OpenShiftException {
            return super.execute(new StringParameter("event", "add-alias"), new StringParameter("alias", alias));
        }
    }

    private class AddEmbeddedCartridgeRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        private AddEmbeddedCartridgeRequest() {
            super(ApplicationResource.LINK_ADD_CARTRIDGE);
        }

        protected <DTO> DTO execute(IEmbeddableCartridge embeddable) throws OpenShiftException {
            return super.execute(new AbstractOpenShiftResource.Parameters().addCartridge(embeddable).toArray());
        }
    }

    private class DeleteApplicationRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        private DeleteApplicationRequest() {
            super(ApplicationResource.LINK_DELETE_APPLICATION);
        }
    }

    private class ForceStopApplicationRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        private ForceStopApplicationRequest() {
            super(ApplicationResource.LINK_FORCE_STOP_APPLICATION);
        }

        protected <DTO> DTO execute() throws OpenShiftException {
            return super.execute(new StringParameter("event", "force-stop"));
        }
    }

    private class GetGearGroupsRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        private GetGearGroupsRequest() {
            super(ApplicationResource.LINK_GET_GEAR_GROUPS);
        }
    }

    private class ListCartridgesRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        private ListCartridgesRequest() {
            super(ApplicationResource.LINK_LIST_CARTRIDGES);
        }

        protected Map<String, CartridgeResourceDTO> execute() throws OpenShiftException {
            return (Map)super.execute(new Parameter[0]);
        }
    }

    private class RemoveAliasRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        private RemoveAliasRequest() {
            super(ApplicationResource.LINK_REMOVE_ALIAS);
        }

        protected <DTO> DTO execute(String alias) throws OpenShiftException {
            return super.execute(new StringParameter("event", "remove-alias"), new StringParameter("alias", alias));
        }
    }

    private class RestartApplicationRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        private RestartApplicationRequest() {
            super(ApplicationResource.LINK_RESTART_APPLICATION);
        }

        protected <DTO> DTO execute() throws OpenShiftException {
            return super.execute(new StringParameter("event", "restart"));
        }
    }

    private class ScaleDownRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        private ScaleDownRequest() {
            super(ApplicationResource.LINK_SCALE_DOWN);
        }

        protected <DTO> DTO execute() throws OpenShiftException {
            return super.execute(new StringParameter("event", "scale-down"));
        }
    }

    private class ScaleUpRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        private ScaleUpRequest() {
            super(ApplicationResource.LINK_SCALE_UP);
        }

        protected <DTO> DTO execute() throws OpenShiftException {
            return super.execute(new StringParameter("event", "scale-up"));
        }
    }

    protected static enum SshStreams {
        EXT_INPUT{

            @Override
            protected InputStream getInputStream(Channel channel) throws IOException {
                return channel.getExtInputStream();
            }
        }
        ,
        INPUT{

            @Override
            protected InputStream getInputStream(Channel channel) throws IOException {
                return channel.getInputStream();
            }
        };


        public List<String> getLines(Channel channel) throws IOException {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.getInputStream(channel)));
            ArrayList<String> lines = new ArrayList<String>();
            String line = null;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            return lines;
        }

        protected abstract InputStream getInputStream(Channel var1) throws IOException;
    }

    private class StartApplicationRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        private StartApplicationRequest() {
            super(ApplicationResource.LINK_START_APPLICATION);
        }

        protected <DTO> DTO execute() throws OpenShiftException {
            return super.execute(new StringParameter("event", "start"));
        }
    }

    private class StopApplicationRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        private StopApplicationRequest() {
            super(ApplicationResource.LINK_STOP_APPLICATION);
        }

        protected <DTO> DTO execute() throws OpenShiftException {
            return super.execute(new StringParameter("event", "stop"));
        }
    }
}

