/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client.cartridge;

import com.openshift.client.cartridge.ICartridge;
import java.net.URL;

public abstract class BaseCartridge
implements ICartridge {
    private final String name;
    private String displayName;
    private String description;
    private URL url;

    protected BaseCartridge(String name) {
        this(name, null, null, null);
    }

    protected BaseCartridge(URL url) {
        this(null, url, null, null);
    }

    protected BaseCartridge(String name, URL url) {
        this(name, url, null, null);
    }

    protected BaseCartridge(String name, String displayName, String description) {
        this(name, null, displayName, description);
    }

    protected BaseCartridge(String name, URL url, String displayName, String description) {
        this.name = name;
        this.url = url;
        this.displayName = displayName;
        this.description = description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isDownloadable() {
        return this.url != null;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseCartridge)) {
            return false;
        }
        BaseCartridge other = (BaseCartridge)obj;
        if (this.isDownloadable() && other.isDownloadable()) {
            if (this.getUrl() == null) {
                return other.getUrl() == null;
            }
            return this.getUrl().equals(other.getUrl());
        }
        return !(this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName()));
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[ " + "name=" + this.name + ", url=" + this.url + ", displayName = " + this.displayName + ", description=" + this.description + " ]";
    }
}

