/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client.httpclient;

import com.openshift.client.HttpMethod;
import com.openshift.client.IHttpClient;
import com.openshift.client.utils.Base64Coder;
import com.openshift.internal.client.httpclient.BadRequestException;
import com.openshift.internal.client.httpclient.EncodingException;
import com.openshift.internal.client.httpclient.HttpClientException;
import com.openshift.internal.client.httpclient.InternalServerErrorException;
import com.openshift.internal.client.httpclient.NotFoundException;
import com.openshift.internal.client.httpclient.UnauthorizedException;
import com.openshift.internal.client.httpclient.request.IMediaType;
import com.openshift.internal.client.httpclient.request.Parameter;
import com.openshift.internal.client.httpclient.request.ParameterValueMap;
import com.openshift.internal.client.utils.StreamUtils;
import com.openshift.internal.client.utils.StringUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlConnectionHttpClient
implements IHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(UrlConnectionHttpClient.class);
    private static final String USERAGENT_FOR_KEYAUTH = "OpenShift";
    protected String userAgent;
    protected boolean sslChecks;
    protected String username;
    protected String password;
    protected String authKey;
    protected String authIV;
    protected String acceptedMediaType;
    protected String acceptedVersion;

    public UrlConnectionHttpClient(String username, String password, String userAgent, boolean sslChecks, String acceptedMediaType, String version) {
        this(username, password, userAgent, sslChecks, acceptedMediaType, version, null, null);
    }

    public UrlConnectionHttpClient(String username, String password, String userAgent, boolean sslChecks, String acceptedMediaType, String version, String authKey, String authIV) {
        this.username = username;
        this.password = password;
        this.userAgent = this.setupUserAgent(authKey, authIV, userAgent);
        this.sslChecks = sslChecks;
        this.acceptedMediaType = acceptedMediaType;
        this.acceptedVersion = version;
        this.authKey = authKey;
        this.authIV = authIV;
    }

    @Override
    public String get(URL url, int timeout) throws HttpClientException, SocketTimeoutException {
        return this.request(HttpMethod.GET, url, null, timeout, new Parameter[0]);
    }

    @Override
    public String put(URL url, IMediaType mediaType, int timeout, Parameter ... parameters) throws HttpClientException, SocketTimeoutException, EncodingException {
        return this.request(HttpMethod.PUT, url, mediaType, timeout, parameters);
    }

    @Override
    public String post(URL url, IMediaType mediaType, int timeout, Parameter ... parameters) throws HttpClientException, SocketTimeoutException, EncodingException {
        return this.request(HttpMethod.POST, url, mediaType, timeout, parameters);
    }

    @Override
    public String delete(URL url, IMediaType mediaType, int timeout, Parameter ... parameters) throws HttpClientException, SocketTimeoutException, EncodingException {
        return this.request(HttpMethod.DELETE, url, mediaType, timeout, parameters);
    }

    @Override
    public String delete(URL url, int timeout) throws HttpClientException, SocketTimeoutException, EncodingException {
        return this.delete(url, null, timeout, new Parameter[0]);
    }

    protected String request(HttpMethod httpMethod, URL url, IMediaType requestMediaType, int timeout, Parameter ... parameters) throws SocketTimeoutException, HttpClientException {
        return this.request(httpMethod, url, requestMediaType, timeout, new ParameterValueMap(parameters));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String request(HttpMethod httpMethod, URL url, IMediaType requestMediaType, int timeout, ParameterValueMap parameters) throws SocketTimeoutException, HttpClientException {
        HttpURLConnection connection = null;
        try {
            connection = this.createConnection(url, this.username, this.password, this.authKey, this.authIV, this.userAgent, this.acceptedVersion, this.acceptedMediaType, timeout);
            connection.setRequestMethod(httpMethod.toString());
            if (!parameters.isEmpty()) {
                connection.setDoOutput(true);
                this.setRequestMediaType(requestMediaType, connection);
                requestMediaType.writeTo(parameters, connection.getOutputStream());
            }
            String string = StreamUtils.readToString(connection.getInputStream());
            this.disconnect(connection);
            return string;
        }
        catch (SocketTimeoutException e) {
            try {
                throw e;
                catch (IOException e2) {
                    throw this.createException(e2, connection);
                }
            }
            catch (Throwable throwable) {
                this.disconnect(connection);
                throw throwable;
            }
        }
    }

    private void disconnect(HttpURLConnection connection) {
        if (connection != null) {
            connection.disconnect();
        }
    }

    private HttpClientException createException(IOException ioe, HttpURLConnection connection) throws SocketTimeoutException {
        try {
            int responseCode = connection.getResponseCode();
            String errorMessage = this.createErrorMessage(ioe, connection);
            switch (responseCode) {
                case 500: {
                    return new InternalServerErrorException(errorMessage, ioe);
                }
                case 400: {
                    return new BadRequestException(errorMessage, ioe);
                }
                case 401: {
                    return new UnauthorizedException(errorMessage, ioe);
                }
                case 404: {
                    return new NotFoundException(errorMessage, ioe);
                }
            }
            return new HttpClientException(errorMessage, ioe);
        }
        catch (SocketTimeoutException e) {
            throw e;
        }
        catch (IOException e) {
            return new HttpClientException(e);
        }
    }

    protected String createErrorMessage(IOException ioe, HttpURLConnection connection) throws IOException {
        String errorMessage = StreamUtils.readToString(connection.getErrorStream());
        if (!StringUtils.isEmpty(errorMessage)) {
            return errorMessage;
        }
        StringBuilder builder = new StringBuilder("Connection to ").append(connection.getURL());
        String reason = connection.getResponseMessage();
        if (!StringUtils.isEmpty(reason)) {
            builder.append(": ").append(reason);
        }
        return builder.toString();
    }

    private boolean isHttps(URL url) {
        return "https".equals(url.getProtocol());
    }

    private void setPermissiveSSLSocketFactory(HttpsURLConnection connection) {
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(new KeyManager[0], new TrustManager[]{new PermissiveTrustManager()}, new SecureRandom());
            SSLSocketFactory socketFactory = sslContext.getSocketFactory();
            connection.setSSLSocketFactory(socketFactory);
        }
        catch (KeyManagementException keyManagementException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    protected HttpURLConnection createConnection(URL url, String username, String password, String authKey, String authIV, String userAgent, String acceptedVersion, String acceptedMediaType, int timeout) throws IOException {
        LOGGER.trace("creating connection to {} using username \"{}\" and password \"{}\"", new Object[]{url, username, password});
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        this.setSSLChecks(url, connection);
        this.setAuthorisation(username, password, authKey, authIV, connection);
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setAllowUserInteraction(false);
        this.setConnectTimeout(connection);
        this.setReadTimeout(timeout, connection);
        connection.setInstanceFollowRedirects(true);
        this.setUserAgent(userAgent, authKey, connection);
        this.setAcceptHeader(acceptedVersion, acceptedMediaType, connection);
        return connection;
    }

    private String setupUserAgent(String authKey, String authIV, String userAgent) {
        if (!StringUtils.isEmpty(authKey)) {
            if (userAgent == null) {
                userAgent = USERAGENT_FOR_KEYAUTH;
            } else if (!userAgent.startsWith(USERAGENT_FOR_KEYAUTH)) {
                userAgent = "OpenShift-" + userAgent;
            }
        }
        return userAgent;
    }

    private void setUserAgent(String userAgent, String authKey, HttpURLConnection connection) {
        if (!StringUtils.isEmpty(userAgent)) {
            connection.setRequestProperty("User-Agent", userAgent);
        }
    }

    private void setAcceptHeader(String acceptedVersion, String acceptedMediaType, HttpURLConnection connection) {
        if (StringUtils.isEmpty(acceptedMediaType)) {
            throw new HttpClientException(MessageFormat.format("Accepted media type (ex. {0}) is not defined", "application/json"));
        }
        StringBuilder builder = new StringBuilder(acceptedMediaType);
        if (acceptedVersion != null) {
            builder.append(';').append(' ').append("version").append('=').append(acceptedVersion);
        }
        connection.setRequestProperty("Accept", builder.toString());
    }

    private void setAuthorisation(String username, String password, String authKey, String authIV, HttpURLConnection connection) {
        if (username == null || username.trim().length() == 0 || password == null || password.trim().length() == 0) {
            if (authKey != null && authIV != null) {
                connection.setRequestProperty("broker_auth_key", authKey);
                connection.setRequestProperty("broker_auth_iv", authIV);
            }
        } else {
            String credentials = Base64Coder.encode((username + ':' + password).getBytes());
            connection.setRequestProperty("Authorization", "Basic" + ' ' + credentials);
        }
    }

    private void setSSLChecks(URL url, HttpURLConnection connection) {
        if (this.isHttps(url) && !this.sslChecks) {
            HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
            httpsConnection.setHostnameVerifier(new NoopHostnameVerifier());
            this.setPermissiveSSLSocketFactory(httpsConnection);
        }
    }

    private void setConnectTimeout(URLConnection connection) {
        int timeout = this.getTimeout(this.getSystemPropertyInteger("com.openshift.httpclient.timeout"), this.getSystemPropertyInteger("sun.net.client.defaultConnectTimeout"), 10000);
        connection.setConnectTimeout(timeout);
    }

    private void setReadTimeout(int timeout, URLConnection connection) {
        timeout = this.getTimeout(timeout, this.getSystemPropertyInteger("sun.net.client.defaultReadTimeout"), 120000);
        connection.setReadTimeout(timeout);
    }

    private int getTimeout(int timeout, int systemPropertyTimeout, int defaultTimeout) {
        if (timeout == -1 && (timeout = systemPropertyTimeout) == -1) {
            timeout = defaultTimeout;
        }
        return timeout;
    }

    private void setRequestMediaType(IMediaType mediaType, HttpURLConnection connection) {
        if (mediaType == null || StringUtils.isEmpty(mediaType.getType())) {
            throw new HttpClientException(MessageFormat.format("Request media type (ex. {0}) is not defined", "application/x-www-form-urlencoded"));
        }
        connection.setRequestProperty("Content-Type", mediaType.getType());
    }

    private int getSystemPropertyInteger(String key) {
        try {
            return Integer.parseInt(System.getProperty(key));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @Override
    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    @Override
    public void setAcceptVersion(String version) {
        this.acceptedVersion = version;
    }

    @Override
    public void setAcceptedMediaType(String acceptedMediaType) {
        this.acceptedMediaType = acceptedMediaType;
    }

    private class NoopHostnameVerifier
    implements HostnameVerifier {
        private NoopHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession sslSession) {
            return true;
        }
    }

    private class PermissiveTrustManager
    implements X509TrustManager {
        private PermissiveTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }
}

