/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client.cartridge;

import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import com.openshift.client.IOpenShiftConnection;
import com.openshift.client.cartridge.ICartridge;
import com.openshift.internal.client.utils.Assert;
import java.util.ArrayList;
import java.util.Collection;

public abstract class AbstractCartridgeQuery {
    public <C extends ICartridge> Collection<C> getAll(Collection<C> cartridges) {
        ArrayList<ICartridge> matchingCartridges = new ArrayList<ICartridge>();
        if (cartridges == null) {
            return matchingCartridges;
        }
        for (ICartridge cartridge : cartridges) {
            if (!this.matches(cartridge)) continue;
            matchingCartridges.add(cartridge);
        }
        return matchingCartridges;
    }

    public <C extends ICartridge> C get(Collection<C> cartridges) {
        Collection<C> matchingCartridges = this.getAll(cartridges);
        if (matchingCartridges == null || matchingCartridges.size() == 0) {
            return null;
        }
        return (C)((ICartridge)matchingCartridges.iterator().next());
    }

    public abstract <C extends ICartridge> boolean matches(C var1);

    protected IOpenShiftConnection getConnection(IApplication application) {
        Assert.notNull(application);
        return application.getDomain().getUser().getConnection();
    }

    protected IOpenShiftConnection getConnection(IDomain domain) {
        Assert.notNull(domain);
        return domain.getUser().getConnection();
    }
}

