/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client.httpclient.request;

import com.openshift.internal.client.httpclient.EncodingException;
import com.openshift.internal.client.httpclient.request.IMediaType;
import com.openshift.internal.client.httpclient.request.Parameter;
import com.openshift.internal.client.httpclient.request.ParameterValue;
import com.openshift.internal.client.httpclient.request.ParameterValueArray;
import com.openshift.internal.client.httpclient.request.ParameterValueMap;
import com.openshift.internal.client.httpclient.request.StringValue;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import org.jboss.dmr.ModelNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonMediaType
implements IMediaType {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonMediaType.class);

    @Override
    public String getType() {
        return "application/json";
    }

    @Override
    public void writeTo(ParameterValueMap parameterMap, OutputStream out) throws EncodingException {
        ModelNode root = new ModelNode();
        for (Parameter parameter : ((Map)parameterMap.getValue()).values()) {
            ModelNode property = root.get(parameter.getName());
            this.create((ParameterValue)parameter.getValue(), property);
        }
        this.writeTo(out, root);
        this.log(root);
    }

    private void create(ParameterValueMap parameterMap, ModelNode node) {
        for (Parameter parameter : ((Map)parameterMap.getValue()).values()) {
            ModelNode property = node.get(parameter.getName());
            this.create((ParameterValue)parameter.getValue(), property);
        }
    }

    private void create(ParameterValue<?> value, ModelNode node) {
        if (StringValue.class.isAssignableFrom(value.getClass())) {
            this.create((StringValue)value, node);
        } else if (ParameterValueArray.class.isAssignableFrom(value.getClass())) {
            this.create((ParameterValueArray)value, node);
        } else if (ParameterValueMap.class.isAssignableFrom(value.getClass())) {
            this.create((ParameterValueMap)value, node);
        }
    }

    private void create(ParameterValueArray array, ModelNode node) {
        for (ParameterValue value : (List)array.getValue()) {
            ModelNode member = new ModelNode();
            this.create(value, member);
            node.add(member);
        }
    }

    private void create(StringValue stringValue, ModelNode node) {
        node.set((String)stringValue.getValue());
    }

    private void writeTo(OutputStream out, ModelNode node) {
        PrintWriter writer = new PrintWriter(out);
        node.writeJSONString(writer, true);
        writer.flush();
    }

    private void log(ModelNode node) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(node.toJSONString(true));
        }
    }
}

