/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client.httpclient;

import com.openshift.client.HttpMethod;
import com.openshift.client.IHttpClient;
import com.openshift.client.utils.Base64Coder;
import com.openshift.client.utils.SSLUtils;
import com.openshift.internal.client.httpclient.BadRequestException;
import com.openshift.internal.client.httpclient.EncodingException;
import com.openshift.internal.client.httpclient.HttpClientException;
import com.openshift.internal.client.httpclient.InternalServerErrorException;
import com.openshift.internal.client.httpclient.NotFoundException;
import com.openshift.internal.client.httpclient.UnauthorizedException;
import com.openshift.internal.client.httpclient.request.IMediaType;
import com.openshift.internal.client.httpclient.request.Parameter;
import com.openshift.internal.client.httpclient.request.ParameterValueMap;
import com.openshift.internal.client.utils.StreamUtils;
import com.openshift.internal.client.utils.StringUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlConnectionHttpClient
implements IHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(UrlConnectionHttpClient.class);
    protected String userAgent;
    protected String username;
    protected String password;
    protected String authKey;
    protected String authIV;
    protected String token;
    protected String acceptedMediaType;
    protected String acceptedVersion;
    protected IHttpClient.ISSLCertificateCallback sslAuthorizationCallback;
    protected Integer configTimeout;
    private String excludedSSLCipherRegex;

    public UrlConnectionHttpClient(String username, String password, String userAgent, String acceptedMediaType, String version) {
        this(username, password, userAgent, acceptedMediaType, version, null, null);
    }

    public UrlConnectionHttpClient(String username, String password, String userAgent, String acceptedMediaType, String version, String authKey, String authIV) {
        this(username, password, userAgent, acceptedMediaType, version, authKey, authIV, null, null, null, null);
    }

    public UrlConnectionHttpClient(String username, String password, String userAgent, String acceptedMediaType, String version, String authKey, String authIV, String token, IHttpClient.ISSLCertificateCallback callback, Integer configTimeout, String excludedSSLCipherRegex) {
        this.username = username;
        this.password = password;
        this.userAgent = userAgent;
        this.acceptedMediaType = acceptedMediaType;
        this.acceptedVersion = version;
        this.authKey = authKey;
        this.authIV = authIV;
        this.token = token;
        this.sslAuthorizationCallback = callback;
        this.configTimeout = configTimeout;
        this.excludedSSLCipherRegex = excludedSSLCipherRegex;
    }

    @Override
    public String get(URL url, int timeout) throws HttpClientException, SocketTimeoutException {
        return this.request(HttpMethod.GET, url, null, timeout, new Parameter[0]);
    }

    @Override
    public String head(URL url, int timeout) throws HttpClientException, SocketTimeoutException {
        return this.request(HttpMethod.HEAD, url, null, timeout, new Parameter[0]);
    }

    @Override
    public String put(URL url, IMediaType mediaType, int timeout, Parameter ... parameters) throws HttpClientException, SocketTimeoutException, EncodingException {
        return this.request(HttpMethod.PUT, url, mediaType, timeout, parameters);
    }

    @Override
    public String post(URL url, IMediaType mediaType, int timeout, Parameter ... parameters) throws HttpClientException, SocketTimeoutException, EncodingException {
        return this.request(HttpMethod.POST, url, mediaType, timeout, parameters);
    }

    @Override
    public String patch(URL url, IMediaType mediaType, int timeout, Parameter ... parameters) throws HttpClientException, SocketTimeoutException, EncodingException {
        return this.request(HttpMethod.PATCH, url, mediaType, timeout, parameters);
    }

    @Override
    public String delete(URL url, IMediaType mediaType, int timeout, Parameter ... parameters) throws HttpClientException, SocketTimeoutException, EncodingException {
        return this.request(HttpMethod.DELETE, url, mediaType, timeout, parameters);
    }

    @Override
    public String delete(URL url, int timeout) throws HttpClientException, SocketTimeoutException, EncodingException {
        return this.delete(url, null, timeout, new Parameter[0]);
    }

    protected String request(HttpMethod httpMethod, URL url, IMediaType requestMediaType, int timeout, Parameter ... parameters) throws SocketTimeoutException, HttpClientException {
        return this.request(httpMethod, url, requestMediaType, timeout, new ParameterValueMap(parameters));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String request(HttpMethod httpMethod, URL url, IMediaType requestMediaType, int timeout, ParameterValueMap parameters) throws SocketTimeoutException, HttpClientException {
        HttpURLConnection connection = null;
        try {
            connection = this.createConnection(url, this.username, this.password, this.authKey, this.authIV, this.token, this.userAgent, this.acceptedVersion, this.acceptedMediaType, this.sslAuthorizationCallback, timeout);
            this.setRequestMethod(httpMethod, connection);
            if (!parameters.isEmpty()) {
                connection.setDoOutput(true);
                this.setRequestMediaType(requestMediaType, connection);
                requestMediaType.writeTo(parameters, connection.getOutputStream());
            }
            String string = StreamUtils.readToString(connection.getInputStream(), "UTF-8");
            this.disconnect(connection);
            return string;
        }
        catch (SocketTimeoutException e) {
            try {
                throw e;
                catch (IOException e2) {
                    throw this.createException(e2, connection);
                }
            }
            catch (Throwable throwable) {
                this.disconnect(connection);
                throw throwable;
            }
        }
    }

    private void setRequestMethod(HttpMethod httpMethod, HttpURLConnection connection) throws ProtocolException {
        if (httpMethod == HttpMethod.PATCH) {
            httpMethod = HttpMethod.POST;
            connection.setRequestProperty("X-Http-Method-Override", "PATCH");
        }
        connection.setRequestMethod(httpMethod.toString());
    }

    private void disconnect(HttpURLConnection connection) {
        if (connection != null) {
            connection.disconnect();
        }
    }

    private HttpClientException createException(IOException ioe, HttpURLConnection connection) throws SocketTimeoutException {
        try {
            int responseCode = connection.getResponseCode();
            String errorMessage = this.createErrorMessage(ioe, connection);
            switch (responseCode) {
                case 500: {
                    return new InternalServerErrorException(errorMessage, ioe);
                }
                case 400: {
                    return new BadRequestException(errorMessage, ioe);
                }
                case 401: {
                    return new UnauthorizedException(errorMessage, ioe);
                }
                case 404: {
                    return new NotFoundException(errorMessage, ioe);
                }
            }
            return new HttpClientException(errorMessage, ioe);
        }
        catch (SocketTimeoutException e) {
            throw e;
        }
        catch (IOException e) {
            return new HttpClientException(e);
        }
    }

    protected String createErrorMessage(IOException ioe, HttpURLConnection connection) throws IOException {
        String errorMessage = StreamUtils.readToString(connection.getErrorStream());
        if (!StringUtils.isEmpty(errorMessage)) {
            return errorMessage;
        }
        StringBuilder builder = new StringBuilder("Connection to ").append(connection.getURL());
        String reason = connection.getResponseMessage();
        if (!StringUtils.isEmpty(reason)) {
            builder.append(": ").append(reason);
        }
        return builder.toString();
    }

    private boolean isHttps(URL url) {
        return "https".equals(url.getProtocol());
    }

    protected HttpURLConnection createConnection(URL url, String username, String password, String authKey, String authIV, String token, String userAgent, String acceptedVersion, String acceptedMediaType, IHttpClient.ISSLCertificateCallback callback, int timeout) throws IOException {
        LOGGER.trace("creating connection to {} using username \"{}\" and password \"{}\" or token \"{}\"", new Object[]{url, username, password, token});
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        if (this.isHttps(url)) {
            HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
            SSLContext sslContext = this.setSSLCallback(this.sslAuthorizationCallback, url, httpsConnection);
            this.setFilteredCiphers(this.excludedSSLCipherRegex, sslContext, httpsConnection);
        }
        this.setAuthorization(username, password, authKey, authIV, token, connection);
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setAllowUserInteraction(false);
        this.setConnectTimeout(-1, connection);
        this.setReadTimeout(timeout, connection);
        connection.setInstanceFollowRedirects(true);
        this.setUserAgent(userAgent, authKey, connection);
        this.setAcceptHeader(acceptedVersion, acceptedMediaType, connection);
        return connection;
    }

    private void setUserAgent(String userAgent, String authKey, HttpURLConnection connection) {
        if (!StringUtils.isEmpty(userAgent)) {
            connection.setRequestProperty("User-Agent", userAgent);
        }
    }

    private void setAcceptHeader(String acceptedVersion, String acceptedMediaType, HttpURLConnection connection) {
        if (StringUtils.isEmpty(acceptedMediaType)) {
            throw new HttpClientException(MessageFormat.format("Accepted media type (ex. {0}) is not defined", "application/json"));
        }
        StringBuilder builder = new StringBuilder(acceptedMediaType);
        if (acceptedVersion != null) {
            builder.append(';').append(' ').append("version").append('=').append(acceptedVersion);
        }
        connection.setRequestProperty("Accept", builder.toString());
    }

    private void setAuthorization(String username, String password, String authKey, String authIV, String token, HttpURLConnection connection) {
        if (username == null || username.trim().length() == 0 || password == null || password.trim().length() == 0) {
            if (authKey != null && authIV != null) {
                connection.setRequestProperty("broker_auth_key", authKey);
                connection.setRequestProperty("broker_auth_iv", authIV);
            } else if (token != null) {
                connection.setRequestProperty("Authorization", "Bearer" + ' ' + token);
            }
        } else {
            String credentials = Base64Coder.encode((username + ':' + password).getBytes());
            connection.setRequestProperty("Authorization", "Basic" + ' ' + credentials);
        }
    }

    private SSLContext setSSLCallback(IHttpClient.ISSLCertificateCallback sslAuthorizationCallback, URL url, HttpsURLConnection connection) {
        X509TrustManager trustManager = null;
        if (sslAuthorizationCallback != null) {
            connection.setHostnameVerifier(new CallbackHostnameVerifier());
            trustManager = this.createCallbackTrustManager(sslAuthorizationCallback, connection);
        }
        try {
            SSLContext sslContext = SSLUtils.getSSLContext(trustManager);
            connection.setSSLSocketFactory(sslContext.getSocketFactory());
            return sslContext;
        }
        catch (GeneralSecurityException e) {
            LOGGER.warn("Could not install trust manager callback", (Throwable)e);
            return null;
        }
    }

    private X509TrustManager createCallbackTrustManager(IHttpClient.ISSLCertificateCallback sslAuthorizationCallback, HttpsURLConnection connection) {
        X509TrustManager trustManager = null;
        try {
            trustManager = this.getCurrentTrustManager();
            if (trustManager == null) {
                LOGGER.warn("Could not install trust manager callback, no trustmanager was found.", (Object)trustManager);
            } else {
                trustManager = new CallbackTrustManager(trustManager, sslAuthorizationCallback);
            }
        }
        catch (GeneralSecurityException e) {
            LOGGER.warn("Could not install trust manager callback.", (Throwable)e);
        }
        return trustManager;
    }

    protected SSLContext setFilteredCiphers(String excludedSSLCipherRegex, SSLContext sslContext, HttpsURLConnection connection) {
        if (excludedSSLCipherRegex != null) {
            connection.setSSLSocketFactory(new EnabledCiphersSSLSocketFactory(SSLUtils.filterCiphers(excludedSSLCipherRegex, this.getSupportedCiphers(sslContext)), sslContext.getSocketFactory()));
        }
        return sslContext;
    }

    protected String[] getSupportedCiphers(SSLContext sslContext) {
        return sslContext.getSupportedSSLParameters().getCipherSuites();
    }

    private void setConnectTimeout(int timeout, URLConnection connection) {
        if (this.getTimeout(timeout) != -1) {
            connection.setConnectTimeout(this.getTimeout(timeout));
        }
    }

    private void setReadTimeout(int timeout, URLConnection connection) {
        if (this.getTimeout(timeout) != -1) {
            connection.setReadTimeout(this.getTimeout(timeout));
        }
    }

    private int getTimeout(int timeout) {
        if (timeout == -1 && this.configTimeout != null) {
            timeout = this.configTimeout;
        }
        return timeout;
    }

    private void setRequestMediaType(IMediaType mediaType, HttpURLConnection connection) {
        if (mediaType == null || StringUtils.isEmpty(mediaType.getType())) {
            throw new HttpClientException(MessageFormat.format("Request media type (ex. {0}) is not defined", "application/x-www-form-urlencoded"));
        }
        connection.setRequestProperty("Content-Type", mediaType.getType());
    }

    private X509TrustManager getCurrentTrustManager() throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        X509TrustManager x509TrustManager = null;
        for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            x509TrustManager = (X509TrustManager)trustManager;
            break;
        }
        return x509TrustManager;
    }

    @Override
    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    @Override
    public void setAcceptVersion(String version) {
        this.acceptedVersion = version;
    }

    @Override
    public void setAcceptedMediaType(String acceptedMediaType) {
        this.acceptedMediaType = acceptedMediaType;
    }

    private static class EnabledCiphersSSLSocketFactory
    extends SSLSocketFactory {
        private String[] enabledCiphers;
        private SSLSocketFactory socketFactory;

        EnabledCiphersSSLSocketFactory(String[] enabledCiphers, SSLSocketFactory socketFactory) {
            this.enabledCiphers = enabledCiphers;
            this.socketFactory = socketFactory;
        }

        @Override
        public Socket createSocket(InetAddress host, int port, InetAddress localHost, int localPort) throws IOException {
            return this.setEnabledCiphers((SSLSocket)this.socketFactory.createSocket(host, port, localHost, localPort));
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
            return this.setEnabledCiphers((SSLSocket)this.socketFactory.createSocket(host, port, localHost, localPort));
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            return this.setEnabledCiphers((SSLSocket)this.socketFactory.createSocket(host, port));
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            return this.setEnabledCiphers((SSLSocket)this.socketFactory.createSocket(host, port));
        }

        @Override
        public String[] getSupportedCipherSuites() {
            if (this.enabledCiphers == null) {
                return this.socketFactory.getSupportedCipherSuites();
            }
            return this.enabledCiphers;
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.socketFactory.getDefaultCipherSuites();
        }

        @Override
        public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
            return this.setEnabledCiphers((SSLSocket)this.socketFactory.createSocket(socket, host, port, autoClose));
        }

        private SSLSocket setEnabledCiphers(SSLSocket socket) {
            if (this.enabledCiphers == null) {
                return socket;
            }
            socket.setEnabledCipherSuites(this.enabledCiphers);
            return socket;
        }
    }

    private class CallbackHostnameVerifier
    implements HostnameVerifier {
        private CallbackHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return UrlConnectionHttpClient.this.sslAuthorizationCallback.allowHostname(hostname, session);
        }
    }

    public class CallbackTrustManager
    implements X509TrustManager {
        private X509TrustManager trustManager;
        private IHttpClient.ISSLCertificateCallback callback;

        private CallbackTrustManager(X509TrustManager currentTrustManager, IHttpClient.ISSLCertificateCallback callback) throws NoSuchAlgorithmException, KeyStoreException {
            this.trustManager = currentTrustManager;
            this.callback = callback;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.trustManager.getAcceptedIssuers();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            block2: {
                try {
                    this.trustManager.checkServerTrusted(chain, authType);
                }
                catch (CertificateException e) {
                    if (this.callback.allowCertificate(chain)) break block2;
                    throw e;
                }
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.trustManager.checkServerTrusted(chain, authType);
        }
    }
}

