/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.client;

import com.openshift.client.HttpMethod;
import com.openshift.client.IHttpClient;
import com.openshift.client.IOpenShiftConnection;
import com.openshift.client.NoopSSLCertificateCallback;
import com.openshift.client.OpenShiftException;
import com.openshift.client.configuration.AbstractOpenshiftConfiguration;
import com.openshift.client.configuration.IOpenShiftConfiguration;
import com.openshift.client.configuration.OpenShiftConfiguration;
import com.openshift.client.utils.SSLUtils;
import com.openshift.internal.client.APIResource;
import com.openshift.internal.client.IRestService;
import com.openshift.internal.client.RestService;
import com.openshift.internal.client.httpclient.UrlConnectionHttpClientBuilder;
import com.openshift.internal.client.httpclient.request.JsonMediaType;
import com.openshift.internal.client.httpclient.request.Parameter;
import com.openshift.internal.client.response.Link;
import com.openshift.internal.client.response.OpenShiftJsonDTOFactory;
import com.openshift.internal.client.response.RestResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;

public class ConnectionBuilder {
    private String serverUrl;
    private IOpenShiftConfiguration configuration = this.createConfiguration();

    public ConnectionBuilder() throws OpenShiftException, IOException {
        this(null);
    }

    public ConnectionBuilder(String serverUrl) throws OpenShiftException, IOException {
        if (serverUrl == null) {
            serverUrl = this.configuration.getLibraServer();
        }
        this.serverUrl = serverUrl;
    }

    protected IOpenShiftConfiguration getConfiguration() {
        return this.configuration;
    }

    public CredentialsConnectionBuilder credentials(String username, String password) {
        return new CredentialsConnectionBuilder(username, password, this.serverUrl, this.configuration);
    }

    public CredentialsConnectionBuilder credentials(String password) {
        return this.credentials(this.configuration.getRhlogin(), password);
    }

    public TokenConnectionBuilder token(String token) {
        return new TokenConnectionBuilder(token, this.serverUrl, this.configuration);
    }

    public KeyConnectionBuilder key(String authIV, String authKey) {
        return new KeyConnectionBuilder(authIV, authKey, this.serverUrl, this.configuration);
    }

    protected IOpenShiftConfiguration createConfiguration() throws IOException {
        if (this.configuration == null) {
            this.configuration = new OpenShiftConfiguration();
        }
        return this.configuration;
    }

    public abstract class AbstractConnectionBuilder {
        protected String serverUrl;
        protected String clientId;
        protected IHttpClient.ISSLCertificateCallback callback;
        protected String sslCipherExclusionRegex;
        protected IOpenShiftConfiguration configuration;
        protected int timeout;

        protected AbstractConnectionBuilder(String serverUrl, IOpenShiftConfiguration configuration) {
            this.serverUrl = serverUrl;
            this.configuration = configuration;
            this.disableBadSSLCiphers(configuration.getDisableBadSSLCiphers());
        }

        public AbstractConnectionBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public AbstractConnectionBuilder sslCertificateCallback(IHttpClient.ISSLCertificateCallback callback) {
            this.callback = callback;
            return this;
        }

        public AbstractConnectionBuilder disableSSLCertificateChecks() {
            return this.sslCertificateCallback(new NoopSSLCertificateCallback());
        }

        public AbstractConnectionBuilder sslCipherExclusion(String sslCipherExclusionRegex) {
            this.sslCipherExclusionRegex = sslCipherExclusionRegex;
            return this;
        }

        public AbstractConnectionBuilder disableBadSSLCiphers(AbstractOpenshiftConfiguration.ConfigurationOptions option) {
            this.sslCipherExclusionRegex = this.createCipherExclusionRegex(option);
            return this;
        }

        public AbstractConnectionBuilder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public abstract IOpenShiftConnection create();

        protected String createCipherExclusionRegex(AbstractOpenshiftConfiguration.ConfigurationOptions option) {
            if (option == AbstractOpenshiftConfiguration.ConfigurationOptions.YES || option == AbstractOpenshiftConfiguration.ConfigurationOptions.AUTO && !SSLUtils.supportsDHECipherKeysOf(1088)) {
                return ".*_DHE_.*";
            }
            return null;
        }

        protected IRestService createRestService(IHttpClient httpClient) {
            return new RestService(this.serverUrl, this.clientId, new JsonMediaType(), "application/json", new OpenShiftJsonDTOFactory(), httpClient);
        }

        public IHttpClient createHttpClient(String clientId, String username, String password, String authKey, String authIV, String token, String serverUrl, int timeout, IHttpClient.ISSLCertificateCallback sslCertificateCallback, String exludeSSLCipherRegex) {
            return new UrlConnectionHttpClientBuilder().setCredentials(username, password, authKey, authIV, token).setConfigTimeout(timeout).setSSLCertificateCallback(sslCertificateCallback).excludeSSLCipher(exludeSSLCipherRegex).client();
        }

        protected APIResource getAPIResource(String username, String password, String token, IRestService service) {
            RestResponse response = service.request(new Link("Get API", "/api", HttpMethod.GET), -1, Collections.<Parameter>emptyList(), Collections.<Parameter>emptyList(), new Parameter[0]);
            return new APIResource(username, password, token, service, (Map)response.getData()){};
        }
    }

    public class CredentialsConnectionBuilder
    extends AbstractConnectionBuilder {
        private final String username;
        private final String password;

        CredentialsConnectionBuilder(String username, String password, String serverUrl, IOpenShiftConfiguration configuration) {
            super(serverUrl, configuration);
            this.username = username;
            this.password = password;
        }

        @Override
        public IOpenShiftConnection create() {
            IHttpClient client = this.createHttpClient(this.clientId, this.username, this.password, null, null, null, this.serverUrl, this.timeout, this.callback, this.sslCipherExclusionRegex);
            return this.getAPIResource(this.username, this.password, null, this.createRestService(client));
        }

        public IOpenShiftConnection create(IHttpClient client) {
            return this.getAPIResource(this.username, this.password, null, this.createRestService(client));
        }
    }

    public class TokenConnectionBuilder
    extends AbstractConnectionBuilder {
        private final String token;

        protected TokenConnectionBuilder(String token, String serverUrl, IOpenShiftConfiguration configuration) {
            super(serverUrl, configuration);
            this.token = token;
        }

        @Override
        public IOpenShiftConnection create() {
            IHttpClient client = this.createHttpClient(this.clientId, null, null, null, null, this.token, this.serverUrl, this.timeout, this.callback, this.sslCipherExclusionRegex);
            return this.getAPIResource(null, null, this.token, this.createRestService(client));
        }
    }

    public class KeyConnectionBuilder
    extends AbstractConnectionBuilder {
        private final String authIV;
        private final String authKey;

        protected KeyConnectionBuilder(String authIV, String authKey, String serverUrl, IOpenShiftConfiguration configuration) {
            super(serverUrl, configuration);
            this.authIV = authIV;
            this.authKey = authKey;
        }

        @Override
        public IOpenShiftConnection create() {
            IHttpClient client = this.createHttpClient(this.clientId, null, null, this.authIV, this.authKey, null, this.serverUrl, this.timeout, this.callback, this.sslCipherExclusionRegex);
            return this.getAPIResource(null, null, null, this.createRestService(client));
        }
    }
}

