/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.client.cartridge.query;

import com.openshift.client.cartridge.ICartridge;
import com.openshift.client.cartridge.query.AbstractCartridgeQuery;
import com.openshift.internal.client.utils.Assert;

public class CartridgeNameQuery
extends AbstractCartridgeQuery {
    private String nameSubstring;

    public CartridgeNameQuery(String nameSubstring) {
        Assert.notEmpty(nameSubstring);
        this.nameSubstring = nameSubstring;
    }

    @Override
    public <C extends ICartridge> boolean matches(C cartridge) {
        if (cartridge == null || cartridge.getName() == null) {
            return false;
        }
        return cartridge.getName().indexOf(this.nameSubstring) >= 0;
    }

    public String toString() {
        return "CartridgeNameQuery [nameSubstring=" + this.nameSubstring + "]";
    }
}

