/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client;

import com.openshift.internal.client.utils.StreamUtils;
import com.openshift.internal.client.utils.StringUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Properties;

public class RestServiceProperties {
    private static final String PROPERTIES_FILE = "restservice.properties";
    static final String KEY_USERAGENTPATTERN = "useragent";
    static final String KEY_VERSION = "version";
    static final String KEY_CLIENTID = "clientid";
    private String version;
    private String userAgent;
    private String clientId;
    private Properties properties;

    public String getVersion() {
        if (this.version == null) {
            this.version = this.getStringProperty(KEY_VERSION);
        }
        return this.version;
    }

    private String getStringProperty(String key) {
        try {
            return this.getProperties().getProperty(key);
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getUseragent(String clientId) {
        String userAgent = null;
        String version = this.getVersion();
        String useragentPattern = this.getUseragentPattern();
        if (!StringUtils.isEmpty(useragentPattern)) {
            userAgent = MessageFormat.format(useragentPattern, StringUtils.nullToEmptyString(version), StringUtils.nullToEmptyString(clientId));
        }
        return userAgent;
    }

    protected String getUseragentPattern() {
        if (this.userAgent == null) {
            this.userAgent = this.getStringProperty(KEY_USERAGENTPATTERN);
        }
        return this.userAgent;
    }

    public String getClientId() {
        if (this.clientId == null) {
            this.clientId = this.getStringProperty(KEY_CLIENTID);
        }
        return this.clientId;
    }

    protected Properties getProperties() throws IOException {
        if (this.properties == null) {
            InputStream in = null;
            try {
                this.properties = new Properties();
                in = this.getClass().getResourceAsStream("/restservice.properties");
                if (in == null) {
                    throw new FileNotFoundException(MessageFormat.format("Could not load properties file {0}", PROPERTIES_FILE));
                }
                this.properties.load(in);
            }
            catch (Throwable throwable) {
                StreamUtils.quietlyClose(in);
                throw throwable;
            }
            StreamUtils.quietlyClose(in);
        }
        return this.properties;
    }
}

