/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.client;

import com.openshift.client.IField;
import com.openshift.client.ISeverity;
import com.openshift.internal.client.Field;
import com.openshift.internal.client.Severity;
import com.openshift.internal.client.utils.StringUtils;
import java.text.MessageFormat;

public class Message {
    private String text;
    private ISeverity severity;
    private IField field;
    private int exitCode;

    public Message(String text, String field, String severity, int exitCode) {
        this.text = text;
        this.severity = new Severity(severity);
        this.field = new Field(field);
        this.exitCode = exitCode;
    }

    public IField getField() {
        return this.field;
    }

    public String getText() {
        return this.text;
    }

    public ISeverity getSeverity() {
        return this.severity;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getOperationState());
        if (!StringUtils.isEmpty(this.field.getValue())) {
            builder.append(" on field \"{0}\",");
        }
        if (!StringUtils.isEmpty(this.severity.getValue())) {
            builder.append(" severity \"{1}\"");
        }
        if (this.exitCode != -1) {
            builder.append(" with exit code \"{2}\"");
        }
        builder.append('.');
        if (!StringUtils.isEmpty(this.text)) {
            builder.append(" Reason given: \"{3}\"");
        }
        return MessageFormat.format(builder.toString(), this.field, this.severity.getValue(), this.exitCode, this.text);
    }

    private String getOperationState() {
        if (ISeverity.INFO.equals(this.severity) || ISeverity.DEBUG.equals(this.severity) || ISeverity.RESULT.equals(this.severity)) {
            return "Operation succeeded";
        }
        if (ISeverity.ERROR.equals(this.severity)) {
            return "Operation failed";
        }
        return "Operation state is " + this.severity.getValue();
    }
}

