/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.client;

import com.openshift.client.IHttpClient;
import com.openshift.client.IOpenShiftConnection;
import com.openshift.client.OpenShiftException;
import com.openshift.client.configuration.AbstractOpenshiftConfiguration;
import com.openshift.client.configuration.IOpenShiftConfiguration;
import com.openshift.client.configuration.OpenShiftConfiguration;
import com.openshift.client.utils.SSLUtils;
import com.openshift.internal.client.AbstractOpenShiftConnectionFactory;
import com.openshift.internal.client.RestService;
import com.openshift.internal.client.httpclient.UrlConnectionHttpClientBuilder;
import com.openshift.internal.client.httpclient.request.JsonMediaType;
import com.openshift.internal.client.response.OpenShiftJsonDTOFactory;
import com.openshift.internal.client.utils.Assert;
import java.io.IOException;

@Deprecated
public class OpenShiftConnectionFactory
extends AbstractOpenShiftConnectionFactory {
    private IOpenShiftConfiguration configuration;

    public IOpenShiftConnection getConnection(String clientId, String password) throws OpenShiftException {
        IOpenShiftConfiguration configuration = this.getConfiguration();
        return this.getConnection(clientId, configuration.getRhlogin(), password, configuration.getLibraServer());
    }

    public IOpenShiftConnection getConnection(String clientId, String username, String password) throws OpenShiftException {
        return this.getConnection(clientId, username, password, this.getConfiguration().getLibraServer());
    }

    public IOpenShiftConnection getConnection(String clientId, String username, String password, String serverUrl) throws OpenShiftException {
        return this.getConnection(clientId, username, password, serverUrl, null);
    }

    public IOpenShiftConnection getConnection(String clientId, String username, String password, String serverUrl, IHttpClient.ISSLCertificateCallback sslCallback) throws OpenShiftException {
        return this.getConnection(clientId, username, password, null, null, null, serverUrl, sslCallback);
    }

    public IOpenShiftConnection getConnection(String clientId, String token, String serverUrl, IHttpClient.ISSLCertificateCallback sslCallback) throws OpenShiftException {
        return this.getConnection(clientId, null, null, null, null, token, serverUrl, sslCallback);
    }

    public IOpenShiftConnection getConnection(String clientId, String username, String password, String authKey, String authIV, String serverUrl) throws OpenShiftException {
        return this.getConnection(clientId, username, password, null, null, null, serverUrl, null);
    }

    public IOpenShiftConnection getConnection(String clientId, String username, String password, String authKey, String authIV, String token, String serverUrl, IHttpClient.ISSLCertificateCallback sslCertificateCallback) throws OpenShiftException {
        return this.getConnection(clientId, username, password, authKey, authIV, token, serverUrl, sslCertificateCallback, this.createCipherExclusionRegex(this.getConfiguration()));
    }

    protected String createCipherExclusionRegex(IOpenShiftConfiguration configuration) {
        if (configuration.getDisableBadSSLCiphers() == AbstractOpenshiftConfiguration.ConfigurationOptions.YES || configuration.getDisableBadSSLCiphers() == AbstractOpenshiftConfiguration.ConfigurationOptions.AUTO && !SSLUtils.supportsDHECipherKeysOf(1088)) {
            return ".*_DHE_.*";
        }
        return null;
    }

    public IOpenShiftConnection getConnection(String clientId, String username, String password, String authKey, String authIV, String token, String serverUrl, IHttpClient.ISSLCertificateCallback sslCertificateCallback, String excludeSSLCipherRegex) throws OpenShiftException {
        Assert.notNull(clientId);
        if (token == null || token.trim().length() == 0) {
            Assert.notNull(username);
            Assert.notNull(password);
        }
        Assert.notNull(serverUrl);
        IHttpClient httpClient = this.createClient(clientId, username, password, authKey, authIV, token, serverUrl, sslCertificateCallback, excludeSSLCipherRegex);
        try {
            return this.getConnection(clientId, username, password, token, serverUrl, httpClient);
        }
        catch (IOException e) {
            throw new OpenShiftException(e, "Failed to establish connection for user ''{0}}''", username);
        }
    }

    protected IHttpClient createClient(String clientId, String username, String password, String authKey, String authIV, String token, String serverUrl, IHttpClient.ISSLCertificateCallback sslCertificateCallback, String exludeSSLCipherRegex) {
        return new UrlConnectionHttpClientBuilder().setCredentials(username, password, authKey, authIV, token).setSSLCertificateCallback(sslCertificateCallback).setConfigTimeout(this.getConfiguration().getTimeout()).excludeSSLCipher(exludeSSLCipherRegex).client();
    }

    protected IOpenShiftConnection getConnection(String clientId, String username, String password, String token, String serverUrl, IHttpClient httpClient) throws OpenShiftException, IOException {
        Assert.notNull(clientId);
        Assert.notNull(serverUrl);
        Assert.notNull(httpClient);
        RestService service = new RestService(serverUrl, clientId, new JsonMediaType(), "application/json", new OpenShiftJsonDTOFactory(), httpClient);
        return this.getConnection(service, username, password, token);
    }

    public IOpenShiftConnection getAuthTokenConnection(String clientId, String token, String serverUrl) throws OpenShiftException {
        return this.getConnection(clientId, null, null, null, null, token, serverUrl, null);
    }

    public IOpenShiftConnection getAuthTokenConnection(String clientId, String token) throws OpenShiftException {
        return this.getConnection(clientId, null, null, null, null, token, this.getConfiguration().getLibraServer(), null);
    }

    protected IOpenShiftConfiguration getConfiguration() throws OpenShiftException {
        if (this.configuration == null) {
            this.configuration = this.createConfiguration();
        }
        return this.configuration;
    }

    protected IOpenShiftConfiguration createConfiguration() throws OpenShiftException {
        try {
            return new OpenShiftConfiguration();
        }
        catch (IOException e) {
            throw new OpenShiftException(e, "Failed to load OpenShift configuration file.", new Object[0]);
        }
    }
}

