/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.client;

import com.jcraft.jsch.KeyPair;
import com.openshift.client.OpenShiftUnknownSSHKeyTypeException;
import com.openshift.internal.client.utils.Assert;

public enum SSHKeyType {
    SSH_RSA("ssh-rsa"),
    SSH_DSA("ssh-dss");

    private final String typeId;

    private SSHKeyType(String typeId) {
        this.typeId = typeId;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public int toJSchKeyType() {
        switch (this) {
            case SSH_RSA: {
                return 2;
            }
            case SSH_DSA: {
                return 1;
            }
        }
        return 3;
    }

    public static SSHKeyType getByTypeId(String keyTypeId) throws OpenShiftUnknownSSHKeyTypeException {
        Assert.notNull(keyTypeId);
        for (SSHKeyType sSHKeyType : SSHKeyType.values()) {
            if (!keyTypeId.equals(sSHKeyType.getTypeId())) continue;
            return sSHKeyType;
        }
        throw new OpenShiftUnknownSSHKeyTypeException("OpenShift does not support keys of type \"{0}\"", keyTypeId);
    }

    public static SSHKeyType getByJSchKeyType(KeyPair keyPair) throws OpenShiftUnknownSSHKeyTypeException {
        Assert.notNull(keyPair);
        return SSHKeyType.getByJSchKeyType(keyPair.getKeyType());
    }

    public static SSHKeyType getByJSchKeyType(int jschKeyType) throws OpenShiftUnknownSSHKeyTypeException {
        if (jschKeyType == 2) {
            return SSH_RSA;
        }
        if (jschKeyType == 1) {
            return SSH_DSA;
        }
        throw new OpenShiftUnknownSSHKeyTypeException("Unknown jsch key type \"{0}\"", jschKeyType);
    }
}

