/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client;

import com.openshift.client.ApplicationScale;
import com.openshift.client.IGearProfile;
import com.openshift.client.IOpenShiftResource;
import com.openshift.client.Message;
import com.openshift.client.Messages;
import com.openshift.client.OpenShiftException;
import com.openshift.client.OpenShiftRequestException;
import com.openshift.client.cartridge.ICartridge;
import com.openshift.internal.client.IRestService;
import com.openshift.internal.client.httpclient.request.Parameter;
import com.openshift.internal.client.httpclient.request.ParameterValue;
import com.openshift.internal.client.httpclient.request.ParameterValueArray;
import com.openshift.internal.client.httpclient.request.ParameterValueMap;
import com.openshift.internal.client.httpclient.request.StringParameter;
import com.openshift.internal.client.response.IRestResponseFactory;
import com.openshift.internal.client.response.Link;
import com.openshift.internal.client.response.RestResponse;
import com.openshift.internal.client.utils.StringUtils;
import com.openshift.internal.client.utils.UrlUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class AbstractOpenShiftResource
implements IOpenShiftResource {
    private Map<String, Link> links;
    private final IRestService service;
    private Messages messages;

    protected AbstractOpenShiftResource(IRestService service) {
        this(service, null, null);
    }

    protected AbstractOpenShiftResource(IRestService service, Map<String, Link> links, Messages messages) {
        this.service = service;
        this.links = links;
        this.messages = messages;
    }

    protected void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    Map<String, Link> getLinks() throws OpenShiftException {
        return this.links;
    }

    IRestService getService() {
        return this.service;
    }

    protected Link getLink(String linkName) throws OpenShiftException {
        Link link = null;
        if (this.getLinks() != null) {
            link = this.getLinks().get(linkName);
        }
        if (link == null) {
            throw new OpenShiftRequestException("Could not find link \"{0}\" in resource \"{1}\"", linkName, this.getClass().getSimpleName());
        }
        return link;
    }

    boolean areLinksLoaded() {
        return this.links != null;
    }

    @Override
    public boolean hasCreationLog() {
        return this.messages != null ? Boolean.valueOf(this.messages.hasMessages()) : null;
    }

    @Override
    public String getCreationLog() {
        if (!this.hasCreationLog()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (Message message : this.messages.getAll()) {
            builder.append(message.getText());
        }
        return builder.toString();
    }

    @Override
    public Messages getMessages() {
        return this.messages;
    }

    protected static class Parameters {
        private List<Parameter> parameters = new ArrayList<Parameter>();

        protected Parameters() {
        }

        protected Parameters addCartridge(ICartridge embeddable) {
            ParameterValueMap parameter = this.createCartridgeParameter(embeddable);
            return this.add(new Parameter("cartridge", parameter));
        }

        protected Parameters addCartridges(Collection<ICartridge> cartridges) {
            ParameterValueArray parameters = new ParameterValueArray();
            if (cartridges != null && cartridges.size() > 0) {
                parameters.addAll(this.createCartridgeParameters(cartridges));
            }
            return this.add(new Parameter("cartridges", parameters));
        }

        protected Parameters addEnvironmentVariables(Map<String, String> environmentVariables) {
            if (environmentVariables == null || environmentVariables.isEmpty()) {
                return this;
            }
            ParameterValueArray parameters = new ParameterValueArray().addAll(this.createEnvironmentVariableParameters(environmentVariables));
            return this.add(new Parameter("environment_variables", parameters));
        }

        private List<ParameterValueMap> createEnvironmentVariableParameters(Map<String, String> environmentVariables) {
            ArrayList<ParameterValueMap> parameters = new ArrayList<ParameterValueMap>();
            if (environmentVariables == null || environmentVariables.isEmpty()) {
                return parameters;
            }
            for (Map.Entry<String, String> environmentVariable : environmentVariables.entrySet()) {
                parameters.add(this.createEnvironmentVariableParameter(environmentVariable.getKey(), environmentVariable.getValue()));
            }
            return parameters;
        }

        private ParameterValueMap createEnvironmentVariableParameter(String name, String value) {
            ParameterValueMap parameters = new ParameterValueMap();
            parameters.add("name", name).add("value", value);
            return parameters;
        }

        private ParameterValueMap createCartridgeParameter(ICartridge cartridge) {
            if (cartridge.isDownloadable()) {
                return new ParameterValueMap().add("url", UrlUtils.toString(cartridge.getUrl()));
            }
            return new ParameterValueMap().add("name", cartridge.getName());
        }

        private List<ParameterValueMap> createCartridgeParameters(Collection<ICartridge> cartridges) {
            ArrayList<ParameterValueMap> parameters = new ArrayList<ParameterValueMap>();
            if (cartridges == null || cartridges.size() == 0) {
                return parameters;
            }
            for (ICartridge cartridge : cartridges) {
                ParameterValueMap parameter = this.createCartridgeParameter(cartridge);
                if (parameter == null) continue;
                parameters.add(parameter);
            }
            return parameters;
        }

        protected Parameters scale(ApplicationScale scale) {
            if (scale == null) {
                return this;
            }
            return this.add(new StringParameter("scale", scale.getValue()));
        }

        protected Parameters gearProfile(IGearProfile gearProfile) {
            if (gearProfile == null) {
                return this;
            }
            return this.add(new StringParameter("gear_profile", gearProfile.getName()));
        }

        protected Parameters region(String region) {
            if (region == null || "".equals(region)) {
                return this;
            }
            return this.add(new StringParameter("region", region));
        }

        protected Parameters include(String includedResource) {
            this.add("include", includedResource);
            return this;
        }

        protected Parameters add(String name, String value) {
            if (StringUtils.isEmpty(value)) {
                return this;
            }
            return this.add(new StringParameter(name, value));
        }

        protected Parameters add(Parameter parameter) {
            if (parameter == null || StringUtils.isEmpty(parameter.getName()) || parameter.getValue() == null || ((ParameterValue)parameter.getValue()).getValue() == null) {
                return this;
            }
            this.parameters.add(parameter);
            return this;
        }

        protected Parameter[] toArray() {
            return this.parameters.toArray(new Parameter[this.parameters.size()]);
        }

        protected List<Parameter> toList() {
            return this.parameters;
        }
    }

    protected class ServiceRequest {
        protected final String linkName;

        protected ServiceRequest(String linkName) {
            this.linkName = linkName;
        }

        protected <DTO> DTO execute(Parameter ... parameters) throws OpenShiftException {
            return this.getData(AbstractOpenShiftResource.this.getService().request(AbstractOpenShiftResource.this.getLink(this.linkName), -1, Collections.<Parameter>emptyList(), Collections.<Parameter>emptyList(), parameters));
        }

        protected <DTO> DTO execute(int timeout, Parameter ... parameters) throws OpenShiftException {
            return this.getData(AbstractOpenShiftResource.this.getService().request(AbstractOpenShiftResource.this.getLink(this.linkName), timeout, Collections.<Parameter>emptyList(), Collections.<Parameter>emptyList(), parameters));
        }

        protected <DTO> DTO execute(List<Parameter> urlParameters, Parameter ... parameters) throws OpenShiftException {
            return this.getData(AbstractOpenShiftResource.this.getService().request(AbstractOpenShiftResource.this.getLink(this.linkName), -1, Collections.<Parameter>emptyList(), urlParameters, parameters));
        }

        protected <DTO> DTO execute(int timeout, List<Parameter> urlParameters, Parameter ... parameters) throws OpenShiftException {
            return this.getData(AbstractOpenShiftResource.this.getService().request(AbstractOpenShiftResource.this.getLink(this.linkName), timeout, Collections.<Parameter>emptyList(), urlParameters, parameters));
        }

        protected <DTO> DTO execute(int timeout, List<Parameter> urlPathParameters, List<Parameter> urlParameters, Parameter ... parameters) throws OpenShiftException {
            return this.getData(AbstractOpenShiftResource.this.getService().request(AbstractOpenShiftResource.this.getLink(this.linkName), timeout, urlPathParameters, urlParameters, parameters));
        }

        protected <DTO> DTO execute(int timeout, IRestResponseFactory responseFactory, List<Parameter> urlPathParameter, List<Parameter> urlParameter, Parameter ... parameters) throws OpenShiftException {
            return this.getData(AbstractOpenShiftResource.this.getService().request(AbstractOpenShiftResource.this.getLink(this.linkName), timeout, responseFactory, urlPathParameter, urlParameter, parameters));
        }

        protected <DTO> DTO getData(RestResponse response) {
            if (response == null) {
                return null;
            }
            return (DTO)response.getData();
        }
    }
}

