/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.openshift.client.IApplication;
import com.openshift.client.IApplicationPortForwarding;
import com.openshift.client.IApplicationSSHSession;
import com.openshift.client.OpenShiftException;
import com.openshift.client.OpenShiftSSHOperationException;
import com.openshift.internal.client.ApplicationResource;
import com.openshift.internal.client.ssh.ApplicationPortForwarding;
import com.openshift.internal.client.utils.StreamUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationSSHSession
implements IApplicationSSHSession {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationSSHSession.class);
    private static final int CONNECT_TIMEOUT = 600000;
    private static final String JSCH_EXEC_CHANNEL = "exec";
    private Session session;
    private IApplication application;
    private List<IApplicationPortForwarding> ports = null;

    public ApplicationSSHSession(IApplication application, Session session) {
        this.application = application;
        this.session = session;
    }

    @Override
    public void setSSHSession(Session session) {
        this.session = session;
    }

    public IApplication getApplication() {
        return this.application;
    }

    @Override
    public boolean isConnected() {
        return this.session.isConnected();
    }

    @Override
    public boolean isPortForwardingStarted() throws OpenShiftSSHOperationException {
        try {
            return this.isConnected() && this.session.getPortForwardingL().length > 0;
        }
        catch (JSchException e) {
            throw new OpenShiftSSHOperationException(e, "Unable to verify if port-forwarding has been started for application \"{0}\"", this.application.getName());
        }
    }

    @Override
    public List<IApplicationPortForwarding> startPortForwarding() throws OpenShiftSSHOperationException {
        this.assertLiveSSHSession();
        for (IApplicationPortForwarding port : this.ports) {
            try {
                port.start(this.session);
            }
            catch (OpenShiftSSHOperationException openShiftSSHOperationException) {}
        }
        return this.ports;
    }

    @Override
    public List<IApplicationPortForwarding> stopPortForwarding() throws OpenShiftSSHOperationException {
        this.assertLiveSSHSession();
        for (IApplicationPortForwarding port : this.ports) {
            try {
                port.stop(this.session);
            }
            catch (OpenShiftSSHOperationException openShiftSSHOperationException) {}
        }
        this.session.disconnect();
        return this.ports;
    }

    @Override
    public List<IApplicationPortForwarding> refreshForwardablePorts() throws OpenShiftSSHOperationException {
        this.assertLiveSSHSession();
        this.ports = this.loadPorts();
        return this.getForwardablePorts();
    }

    @Override
    public List<IApplicationPortForwarding> getForwardablePorts() throws OpenShiftSSHOperationException {
        this.assertLiveSSHSession();
        if (this.ports == null) {
            this.ports = this.loadPorts();
        }
        return this.ports;
    }

    @Override
    public List<String> getEnvironmentProperties() throws OpenShiftSSHOperationException {
        this.assertLiveSSHSession();
        ArrayList<String> openshiftProps = new ArrayList<String>();
        InputStream in = this.execCommand("set", ChannelInputStreams.DATA, this.session);
        try {
            for (String line : new SshCommandResponse(in).getLines()) {
                openshiftProps.add(line);
            }
            return openshiftProps;
        }
        catch (IOException e) {
            throw new OpenShiftSSHOperationException(e, "Could not execute \"set\" command via ssh on application {0}", this.application.getName());
        }
    }

    public InputStream saveFullSnapshot() {
        this.assertLiveSSHSession();
        return new FullSnapshotCommand(this.session).save();
    }

    public InputStream restoreFullSnapshot(InputStream inputStream) {
        return this.restoreFullSnapshot(inputStream, true);
    }

    public InputStream restoreFullSnapshot(InputStream inputStream, boolean includeGit) {
        this.assertLiveSSHSession();
        return new FullSnapshotCommand(this.session).restore(inputStream, includeGit);
    }

    public InputStream saveDeploymentSnapshot() {
        this.assertLiveSSHSession();
        return new DeploymentSnapshotCommand(this.session).save();
    }

    public InputStream restoreDeploymentSnapshot(InputStream inputStream, boolean hotDeploy) throws OpenShiftException {
        return new DeploymentSnapshotCommand(this.session).restore(inputStream, hotDeploy);
    }

    private List<IApplicationPortForwarding> loadPorts() throws OpenShiftSSHOperationException {
        this.assertLiveSSHSession();
        this.ports = new ArrayList<IApplicationPortForwarding>();
        InputStream in = this.execCommand("rhc-list-ports", ChannelInputStreams.EXTENDED_DATA, this.session);
        try {
            this.ports = new RhcListPortsCommandResponse(this.application, in).getPortForwardings();
            List<IApplicationPortForwarding> list = this.ports;
            return list;
        }
        catch (IOException e) {
            throw new OpenShiftSSHOperationException("Could not execute \"rhc-list-ports\" via ssh in application {0}", this.application.getName());
        }
        finally {
            try {
                StreamUtils.close(in);
            }
            catch (IOException e) {
                LOGGER.error("Could not close channel to ssh server", (Throwable)e);
            }
        }
    }

    public void refresh() throws OpenShiftException {
        if (this.ports != null) {
            this.ports = this.loadPorts();
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (object == this) {
            return true;
        }
        ApplicationSSHSession other = (ApplicationSSHSession)object;
        ApplicationResource otherapp = (ApplicationResource)((ApplicationSSHSession)object).getApplication();
        if (this.application.getUUID() == null) {
            if (otherapp.getUUID() != null) {
                return false;
            }
        } else {
            if (!this.application.getUUID().equals(otherapp.getUUID())) {
                return false;
            }
            if (this.isConnected() != other.isConnected()) {
                return false;
            }
            if (this.isPortForwardingStarted() != other.isPortForwardingStarted()) {
                return false;
            }
            if (!this.application.equals(otherapp)) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return "ApplicationSSHSession [applicationuuid=" + this.application.getUUID() + ", applicationname=" + this.application.getName() + ", isconnected=" + this.isConnected() + ", isportforwardingstarted=" + this.isPortForwardingStarted() + "]";
    }

    protected void assertLiveSSHSession() {
        if (!this.isConnected()) {
            throw new OpenShiftSSHOperationException("SSH session for application \"{0}\" is closed.", this.application.getName());
        }
    }

    protected InputStream execCommand(String command, ChannelInputStreams factory, Session session) throws OpenShiftSSHOperationException {
        return this.execCommand(command, null, factory, session);
    }

    protected InputStream execCommand(String command, InputStream forStdIn, ChannelInputStreams channelInputStream, Session session) throws OpenShiftSSHOperationException {
        this.assertLiveSSHSession();
        ChannelExec channel = null;
        try {
            channel = (ChannelExec)session.openChannel(JSCH_EXEC_CHANNEL);
            channel.setCommand(command);
            OutputStream remoteStdIn = channel.getOutputStream();
            InputStream in = channel.getInputStream();
            ChannelResponse channelResponse = new ChannelResponse(in, channel);
            channel.connect(600000);
            if (forStdIn != null) {
                this.writeToRemoteStdInput(forStdIn, remoteStdIn);
            }
            return channelResponse;
        }
        catch (JSchException e) {
            if (channel != null && channel.isConnected()) {
                channel.disconnect();
            }
            throw new OpenShiftSSHOperationException(e, "Could no execute remote ssh command \"{0}\" on application {1}", command, this.application.getName());
        }
        catch (IOException e) {
            if (channel != null && channel.isConnected()) {
                channel.disconnect();
            }
            throw new OpenShiftSSHOperationException(e, "Could not get response channel for remote ssh command \"{0}\" on application {1}", command, this.application.getName());
        }
    }

    private void writeToRemoteStdInput(InputStream forStdInput, OutputStream remoteStdIn) throws IOException {
        int data = -1;
        while ((data = forStdInput.read()) != -1) {
            remoteStdIn.write(data);
        }
        remoteStdIn.close();
        forStdInput.close();
    }

    class ChannelResponse
    extends InputStream {
        private static final int WAIT_DELAY = 1000;
        private ChannelExec channel;
        private InputStream channelInputStream;
        private InputStream channelErrorStream;

        protected ChannelResponse(InputStream response, ChannelExec channel) throws IOException, JSchException {
            this.channel = channel;
            this.channelInputStream = response;
            this.channelErrorStream = channel.getErrStream();
        }

        @Override
        public int read() throws IOException {
            if (this.channel.isClosed() && this.channel.getExitStatus() != 0) {
                throw new IOException(StreamUtils.readToString(this.channelErrorStream));
            }
            while (!this.channel.isClosed() || this.channelInputStream.available() != 0) {
                if (this.channelInputStream.available() > 0) {
                    int data = this.channelInputStream.read();
                    if (data == -1) continue;
                    return data;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            return -1;
        }

        @Override
        public void close() throws IOException {
            this.channel.disconnect();
            this.channelInputStream.close();
        }

        @Override
        public int available() throws IOException {
            return this.channelInputStream.available();
        }
    }

    static enum ChannelInputStreams {
        DATA{

            @Override
            public InputStream get(Channel channel) throws IOException, JSchException {
                return channel.getInputStream();
            }
        }
        ,
        EXTENDED_DATA{

            @Override
            public InputStream get(Channel channel) throws IOException, JSchException {
                return channel.getExtInputStream();
            }
        };


        public abstract InputStream get(Channel var1) throws IOException, JSchException;
    }

    private static class RhcListPortsCommandResponse
    extends SshCommandResponse {
        private static final Pattern REGEX_FORWARDED_PORT = Pattern.compile("([^ ]+) -> ([^:]+):(\\d+)");
        private IApplication application;

        RhcListPortsCommandResponse(IApplication application, InputStream inputStream) {
            super(inputStream);
            this.application = application;
        }

        public List<IApplicationPortForwarding> getPortForwardings() throws IOException {
            ArrayList<IApplicationPortForwarding> ports = new ArrayList<IApplicationPortForwarding>();
            for (String line : this.getLines()) {
                ApplicationPortForwarding port = this.extractForwardablePortFrom(line);
                if (port == null) continue;
                ports.add(port);
            }
            return ports;
        }

        private ApplicationPortForwarding extractForwardablePortFrom(String rhcListPortsOutput) {
            Matcher matcher = REGEX_FORWARDED_PORT.matcher(rhcListPortsOutput);
            if (!matcher.find() || matcher.groupCount() != 3) {
                return null;
            }
            try {
                String name = matcher.group(1);
                String host = matcher.group(2);
                int remotePort = Integer.parseInt(matcher.group(3));
                return new ApplicationPortForwarding(this.application, name, host, remotePort);
            }
            catch (NumberFormatException e) {
                throw new OpenShiftSSHOperationException(e, "Couild not determine forwarded port in application {0}", this.application.getName());
            }
        }
    }

    protected static class SshCommandResponse {
        private InputStream inputStream;

        SshCommandResponse(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        public List<String> getLines() throws IOException {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputStream));
            ArrayList<String> lines = new ArrayList<String>();
            String line = null;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            return lines;
        }
    }

    class DeploymentSnapshotCommand
    extends AbstractSnapshotSshCommand {
        DeploymentSnapshotCommand(Session session) {
            super(session);
        }

        public InputStream save() {
            return ApplicationSSHSession.this.execCommand("gear archive-deployment", ChannelInputStreams.DATA, this.session);
        }

        public InputStream restore(InputStream inputStream, boolean hotDeploy) {
            return ApplicationSSHSession.this.execCommand(MessageFormat.format("oo-binary-deploy{0}", hotDeploy ? " --hot-deploy" : ""), inputStream, ChannelInputStreams.DATA, this.session);
        }
    }

    class FullSnapshotCommand
    extends AbstractSnapshotSshCommand {
        FullSnapshotCommand(Session session) {
            super(session);
        }

        public InputStream save() {
            return ApplicationSSHSession.this.execCommand("snapshot", ChannelInputStreams.DATA, this.session);
        }

        public InputStream restore(InputStream in, boolean includeGit) {
            return ApplicationSSHSession.this.execCommand(MessageFormat.format("restore{0}", includeGit ? " INCLUDE_GIT" : ""), in, ChannelInputStreams.DATA, this.session);
        }
    }

    protected abstract class AbstractSnapshotSshCommand {
        protected Session session;

        AbstractSnapshotSshCommand(Session session) {
            this.session = session;
        }
    }

    public abstract class AbstractSnapshotType {
        private String saveCommand;
        private String restoreCommand;

        private AbstractSnapshotType(String saveCommand, String restoreCommand) {
            this.saveCommand = saveCommand;
            this.restoreCommand = restoreCommand;
        }

        public String getSaveCommand() {
            return this.saveCommand;
        }

        public String getRestoreCommand() {
            return this.restoreCommand;
        }
    }
}

