/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client;

import com.openshift.client.IAuthorization;
import com.openshift.client.OpenShiftException;
import com.openshift.internal.client.APIResource;
import com.openshift.internal.client.AbstractOpenShiftResource;
import com.openshift.internal.client.httpclient.request.Parameter;
import com.openshift.internal.client.httpclient.request.StringParameter;
import com.openshift.internal.client.response.AuthorizationResourceDTO;

public class AuthorizationResource
extends AbstractOpenShiftResource
implements IAuthorization {
    private static final String LINK_GET = "GET";
    private static final String LINK_UPDATE = "UPDATE";
    private static final String LINK_DELETE = "DELETE";
    private String id;
    private String note;
    private String scopes;
    private String token;
    private int expiresIn;
    private APIResource api;

    protected AuthorizationResource(APIResource api, AuthorizationResourceDTO authorizationDTO) {
        super(api.getService(), authorizationDTO.getLinks(), authorizationDTO.getMessages());
        this.api = api;
        this.id = authorizationDTO.getId();
        this.note = authorizationDTO.getNote();
        this.scopes = authorizationDTO.getScopes();
        this.token = authorizationDTO.getToken();
        this.expiresIn = authorizationDTO.getExpiresIn();
    }

    @Override
    public void refresh() throws OpenShiftException {
        AuthorizationResourceDTO authorizationDTO = new GetAuthorizationRequest().execute();
        this.id = authorizationDTO.getId();
        this.note = authorizationDTO.getNote();
        this.scopes = authorizationDTO.getScopes();
        this.token = authorizationDTO.getToken();
        this.expiresIn = authorizationDTO.getExpiresIn();
    }

    public String toString() {
        return "Authorization [id=" + this.id + ", note=" + this.note + ", scopes=" + this.scopes + ", token=" + this.token + ", expiresIn=" + this.expiresIn + "]";
    }

    @Override
    public void destroy() throws OpenShiftException {
        new DeleteAuthorizationRequest().execute(new Parameter[0]);
        this.id = null;
        this.note = null;
        this.scopes = null;
        this.token = null;
        this.expiresIn = -1;
        this.api.removeAuthorization();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getNote() {
        return this.note;
    }

    @Override
    public String getScopes() {
        return this.scopes;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public int getExpiresIn() {
        return this.expiresIn;
    }

    private class DeleteAuthorizationRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        private DeleteAuthorizationRequest() throws OpenShiftException {
            super(AuthorizationResource.this, AuthorizationResource.LINK_DELETE);
        }

        protected void execute(boolean force) throws OpenShiftException {
            super.execute(new StringParameter("force", String.valueOf(force)));
        }
    }

    private class GetAuthorizationRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        private GetAuthorizationRequest() throws OpenShiftException {
            super(AuthorizationResource.this, AuthorizationResource.LINK_GET);
        }

        protected AuthorizationResourceDTO execute() throws OpenShiftException {
            return (AuthorizationResourceDTO)super.execute(new Parameter[0]);
        }
    }
}

