/*******************************************************************************
 * Copyright (c) 2015 Red Hat, Inc. Distributed under license by Red Hat, Inc.
 * All rights reserved. This program is made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Red Hat, Inc.
 ******************************************************************************/
package com.openshift3.internal.client.model.build;

import com.openshift3.client.images.DockerImageURI;
import com.openshift3.client.model.build.BuildTriggerType;
import com.openshift3.client.model.build.IImageChangeTrigger;

public class ImageChangeTrigger implements IImageChangeTrigger {

	private String tag;
	private DockerImageURI image;
	private DockerImageURI from;

	public ImageChangeTrigger(String image, String from, String tag) {
		this.tag = tag;
		this.image = new DockerImageURI(image);
		this.from = new DockerImageURI(from);
	}

	@Override
	public BuildTriggerType getType() {
		return BuildTriggerType.imageChange;
	}

	@Override
	public DockerImageURI getImage() {
		return image;
	}

	@Override
	public DockerImageURI getFrom() {
		return from;
	}

	@Override
	public String getTag() {
		return this.tag;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((from == null) ? 0 : from.hashCode());
		result = prime * result + ((image == null) ? 0 : image.hashCode());
		result = prime * result + ((tag == null) ? 0 : tag.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		ImageChangeTrigger other = (ImageChangeTrigger) obj;
		if (from == null) {
			if (other.from != null)
				return false;
		} else if (!from.equals(other.from))
			return false;
		if (image == null) {
			if (other.image != null)
				return false;
		} else if (!image.equals(other.image))
			return false;
		if (tag == null) {
			if (other.tag != null)
				return false;
		} else if (!tag.equals(other.tag))
			return false;
		return true;
	}
	
}
