/*
 * Decompiled with CFR 0.152.
 */
package com.openshift3.client.authorization;

import com.openshift.client.utils.Base64Coder;
import com.openshift3.client.authorization.IAuthorizationStrategy;
import com.openshift3.client.authorization.IRequest;

public class BasicAuthorizationStrategy
implements IAuthorizationStrategy {
    private final String password;
    private final String username;

    public BasicAuthorizationStrategy(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    @Override
    public void authorize(IRequest request) {
        String value = "Basic " + Base64Coder.encode(String.format("%s:%s", this.username, this.password));
        request.setProperty("Authorization", value);
    }
}

