/*
 * Decompiled with CFR 0.152.
 */
package com.openshift3.client.authorization;

import com.openshift3.client.authorization.BearerTokenAuthorizationStrategy;
import com.openshift3.client.authorization.IAuthorizationClient;
import com.openshift3.client.authorization.IAuthorizationContext;
import com.openshift3.client.authorization.IAuthorizationStrategy;
import com.openshift3.client.authorization.IRequest;

public class OAuthStrategy
implements IAuthorizationStrategy {
    private IAuthorizationClient authclient;
    private IAuthorizationContext context;
    private String baseURL;
    private String username;
    private String password;
    private IAuthorizationStrategy strategy;

    public OAuthStrategy(String baseURL, IAuthorizationClient authclient, String username, String password) {
        this.baseURL = baseURL;
        this.authclient = authclient;
        this.username = username;
        this.password = password;
    }

    @Override
    public void authorize(IRequest request) {
        if (this.context == null) {
            this.context = this.authclient.getContext(this.baseURL, this.username, this.password);
            this.strategy = new BearerTokenAuthorizationStrategy(this.context.getToken());
        }
        this.strategy.authorize(request);
    }
}

