/*
 * Decompiled with CFR 0.152.
 */
package com.openshift3.client.capability;

import com.openshift3.client.IClient;
import com.openshift3.client.capability.ICapability;
import com.openshift3.client.capability.resources.IDeploymentConfigTraceability;
import com.openshift3.client.capability.resources.IDeploymentTraceability;
import com.openshift3.client.capability.resources.ITags;
import com.openshift3.client.capability.resources.ITemplateTraceability;
import com.openshift3.client.capability.server.IImageRegistryHosting;
import com.openshift3.client.capability.server.ITemplateProcessing;
import com.openshift3.client.model.IResource;
import com.openshift3.internal.client.capability.resources.DeploymentConfigTraceability;
import com.openshift3.internal.client.capability.resources.DeploymentTraceability;
import com.openshift3.internal.client.capability.resources.TagCapability;
import com.openshift3.internal.client.capability.resources.TemplateTraceability;
import com.openshift3.internal.client.capability.server.DefaultImageRegistryHosting;
import com.openshift3.internal.client.capability.server.ServerTemplateProcessing;
import java.util.Map;

public class CapabilityInitializer {
    private static void initializeCapability(Map<Class<? extends ICapability>, ICapability> capabilities, Class<? extends ICapability> capability, ICapability impl) {
        if (impl.isSupported()) {
            capabilities.put(capability, impl);
        }
    }

    public static void initializeCapabilities(Map<Class<? extends ICapability>, ICapability> capabilities, IResource resource, IClient client) {
        CapabilityInitializer.initializeCapability(capabilities, ITemplateTraceability.class, new TemplateTraceability(resource));
        CapabilityInitializer.initializeCapability(capabilities, IDeploymentConfigTraceability.class, new DeploymentConfigTraceability(resource, client));
        CapabilityInitializer.initializeCapability(capabilities, IDeploymentTraceability.class, new DeploymentTraceability(resource, client));
        CapabilityInitializer.initializeCapability(capabilities, ITags.class, new TagCapability(resource));
    }

    public static void initializeClientCapabilities(Map<Class<? extends ICapability>, ICapability> capabilities, IClient client) {
        CapabilityInitializer.initializeCapability(capabilities, IImageRegistryHosting.class, new DefaultImageRegistryHosting(client));
        CapabilityInitializer.initializeCapability(capabilities, ITemplateProcessing.class, new ServerTemplateProcessing(client));
    }
}

