/*
 * Decompiled with CFR 0.152.
 */
package com.openshift3.internal.client;

import com.openshift.client.IHttpClient;
import com.openshift.client.OpenShiftException;
import com.openshift.internal.client.httpclient.HttpClientException;
import com.openshift.internal.client.httpclient.UrlConnectionHttpClientBuilder;
import com.openshift3.client.IClient;
import com.openshift3.client.ResourceKind;
import com.openshift3.client.UnsupportedOperationException;
import com.openshift3.client.UnsupportedVersionException;
import com.openshift3.client.authorization.IAuthorizationStrategy;
import com.openshift3.client.capability.CapabilityInitializer;
import com.openshift3.client.capability.CapabilityVisitor;
import com.openshift3.client.capability.ICapability;
import com.openshift3.client.model.IList;
import com.openshift3.client.model.IResource;
import com.openshift3.client.model.IStatus;
import com.openshift3.internal.client.IResourceFactory;
import com.openshift3.internal.client.KubernetesAPIVersion;
import com.openshift3.internal.client.OpenShiftAPIVersion;
import com.openshift3.internal.client.ResourceFactory;
import com.openshift3.internal.client.URLBuilder;
import com.openshift3.internal.client.model.properties.ResourcePropertiesRegistry;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.dmr.ModelNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClient
implements IClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultClient.class);
    private URL baseUrl;
    private IHttpClient client;
    private IResourceFactory factory;
    private Map<Class<? extends ICapability>, ICapability> capabilities = new HashMap<Class<? extends ICapability>, ICapability>();
    private boolean capabilitiesInitialized = false;
    private static final String apiEndpoint = "api";
    private static final String osApiEndpoint = "osapi";
    private final Map<ResourceKind, String> typeMappings = new HashMap<ResourceKind, String>();
    private OpenShiftAPIVersion openShiftVersion;
    private KubernetesAPIVersion kubernetesVersion;

    public DefaultClient(URL baseUrl, IHttpClient.ISSLCertificateCallback sslCertCallback) {
        this(baseUrl, null, sslCertCallback);
    }

    DefaultClient(URL baseUrl, IHttpClient httpClient, IHttpClient.ISSLCertificateCallback sslCertCallback) {
        this.baseUrl = baseUrl;
        this.client = httpClient != null ? httpClient : this.newIHttpClient(sslCertCallback);
        this.factory = new ResourceFactory(this);
    }

    private IHttpClient newIHttpClient(IHttpClient.ISSLCertificateCallback sslCertCallback) {
        return new UrlConnectionHttpClientBuilder().setAcceptMediaType("application/json").setSSLCertificateCallback(sslCertCallback).client();
    }

    @Override
    public IResourceFactory getResourceFactory() {
        return this.factory;
    }

    @Override
    public <T extends IResource> List<T> list(ResourceKind kind) {
        return this.list(kind, "");
    }

    @Override
    public <T extends IResource> List<T> list(ResourceKind kind, String namespace) {
        return this.list(kind, namespace, new HashMap<String, String>());
    }

    @Override
    public <T extends IResource> List<T> list(ResourceKind kind, String namespace, Map<String, String> labels) {
        if (!this.getTypeMappings().containsKey((Object)kind)) {
            throw new RuntimeException("No OpenShift resource endpoint for type: " + (Object)((Object)kind));
        }
        try {
            URLBuilder builder = new URLBuilder(this.baseUrl, this.getTypeMappings()).kind(kind).namespace(namespace);
            URL endpoint = builder.build();
            String response = this.client.get(endpoint, 120000);
            LOGGER.debug(String.format("List Response: %s:", response));
            List<IResource> items = this.factory.createList(response, kind);
            return this.filterItems(items, labels);
        }
        catch (HttpClientException e) {
            throw this.handleHttpClientException("Exception listing the resources", e);
        }
        catch (SocketTimeoutException e) {
            throw new OpenShiftException(e, "SocketTimeout listing resources", new Object[0]);
        }
    }

    private <T extends IResource> List<T> filterItems(List<T> items, Map<String, String> labels) {
        if (labels.isEmpty()) {
            return items;
        }
        ArrayList<IResource> filtered = new ArrayList<IResource>();
        for (IResource item : items) {
            if (!item.getLabels().entrySet().containsAll(labels.entrySet())) continue;
            filtered.add(item);
        }
        return filtered;
    }

    @Override
    public Collection<IResource> create(IList list, String namespace) {
        ArrayList<IResource> results = new ArrayList<IResource>(list.getItems().size());
        for (IResource resource : list.getItems()) {
            try {
                results.add(this.create(resource, namespace));
            }
            catch (com.openshift3.client.OpenShiftException e) {
                if (e.getStatus() != null) {
                    results.add(e.getStatus());
                    continue;
                }
                throw e;
            }
        }
        return results;
    }

    @Override
    public <T extends IResource> T create(T resource) {
        return this.create(resource, resource.getNamespace());
    }

    @Override
    public <T extends IResource> T create(T resource, String namespace) {
        if (resource.getKind() == ResourceKind.List) {
            throw new UnsupportedOperationException("Generic create operation not supported for resource type 'List'");
        }
        try {
            URL endpoint = new URLBuilder(this.baseUrl, this.getTypeMappings()).kind(resource.getKind()).addParmeter("namespace", namespace).build();
            String response = this.client.post(endpoint, 120000, resource);
            LOGGER.debug(response);
            return this.factory.create(response);
        }
        catch (HttpClientException e) {
            throw this.handleHttpClientException("Exception creating the resource", e);
        }
        catch (SocketTimeoutException e) {
            throw new OpenShiftException(e, "SocketTimeout creating resource %", resource.getName());
        }
    }

    @Override
    public <T extends IResource> T update(T resource) {
        if (resource.getKind() == ResourceKind.List) {
            throw new UnsupportedOperationException("Update operation not supported for resource type 'List'");
        }
        try {
            URL endpoint = new URLBuilder(this.getBaseURL(), this.getTypeMappings()).resource(resource).addParmeter("namespace", resource.getNamespace()).build();
            String response = this.client.put(endpoint, 120000, resource);
            LOGGER.debug(response);
            return this.factory.create(response);
        }
        catch (HttpClientException e) {
            throw this.handleHttpClientException("Exception updating the resource", e);
        }
        catch (SocketTimeoutException e) {
            throw new OpenShiftException(e, "SocketTimeout updating resource %", resource.getName());
        }
    }

    @Override
    public <T extends IResource> void delete(T resource) {
        if (resource.getKind() == ResourceKind.List) {
            throw new UnsupportedOperationException("Delete operation not supported for resource type 'List'");
        }
        try {
            URL endpoint = new URLBuilder(this.baseUrl, this.getTypeMappings()).resource(resource).addParmeter("namespace", resource.getNamespace()).build();
            LOGGER.debug(String.format("Deleting resource: %s", endpoint));
            String response = this.client.delete(endpoint, 120000);
            LOGGER.debug(response);
        }
        catch (HttpClientException e) {
            throw this.handleHttpClientException("Exception deleting the resource", e);
        }
        catch (SocketTimeoutException e) {
            throw new OpenShiftException(e, "SocketTimeout deleting resource %", resource.getName());
        }
    }

    @Override
    public <T extends IResource> T get(ResourceKind kind, String name, String namespace) {
        try {
            URL endpoint = new URLBuilder(this.baseUrl, this.getTypeMappings()).kind(kind).name(name).addParmeter("namespace", namespace).build();
            String response = this.client.get(endpoint, 120000);
            LOGGER.debug(response);
            return this.factory.create(response);
        }
        catch (HttpClientException e) {
            throw this.handleHttpClientException("Exception getting the resource", e);
        }
        catch (SocketTimeoutException e) {
            throw new OpenShiftException(e, "SocketTimeout getting resource %", name);
        }
    }

    public synchronized void initializeCapabilities() {
        if (this.capabilitiesInitialized) {
            return;
        }
        CapabilityInitializer.initializeClientCapabilities(this.capabilities, this);
        this.capabilitiesInitialized = true;
    }

    @Override
    public <T extends ICapability> T getCapability(Class<T> capability) {
        return (T)this.capabilities.get(capability);
    }

    @Override
    public boolean supports(Class<? extends ICapability> capability) {
        if (!this.capabilitiesInitialized) {
            this.initializeCapabilities();
        }
        return this.capabilities.containsKey(capability);
    }

    @Override
    public <T extends ICapability> void accept(CapabilityVisitor<T> visitor) {
        if (!this.capabilitiesInitialized) {
            this.initializeCapabilities();
        }
        if (this.capabilities.containsKey(visitor.getCapabilityType())) {
            ICapability capability = this.capabilities.get(visitor.getCapabilityType());
            visitor.visit(capability);
        }
    }

    public List<KubernetesAPIVersion> getKubernetesVersions() {
        return this.getVersion(KubernetesAPIVersion.class, apiEndpoint);
    }

    public List<OpenShiftAPIVersion> getOpenShiftVersions() {
        return this.getVersion(OpenShiftAPIVersion.class, osApiEndpoint);
    }

    public KubernetesAPIVersion getKubernetesVersion() {
        if (this.kubernetesVersion == null) {
            List<KubernetesAPIVersion> versions = this.getKubernetesVersions();
            this.kubernetesVersion = ResourcePropertiesRegistry.getInstance().getMaxSupportedKubernetesVersion();
            if (!versions.contains(this.kubernetesVersion)) {
                throw new RuntimeException(String.format("Kubernetes API version '%s' is not supported by this client", new Object[0]));
            }
        }
        return this.kubernetesVersion;
    }

    @Override
    public String getOpenShiftAPIVersion() throws UnsupportedVersionException {
        return this.getOpenShiftVersion().toString();
    }

    public OpenShiftAPIVersion getOpenShiftVersion() {
        if (this.openShiftVersion == null) {
            List<OpenShiftAPIVersion> versions = this.getOpenShiftVersions();
            this.openShiftVersion = ResourcePropertiesRegistry.getInstance().getMaxSupportedOpenShiftVersion();
            if (!versions.contains(this.openShiftVersion)) {
                throw new UnsupportedVersionException(this.openShiftVersion.toString());
            }
        }
        return this.openShiftVersion;
    }

    private <T extends Enum<T>> List<T> getVersion(Class<T> klass, String endpoint) {
        try {
            URL url = new URL(this.baseUrl, endpoint);
            LOGGER.debug(url.toString());
            String response = this.client.get(url, 120000);
            LOGGER.debug(response);
            ModelNode json = ModelNode.fromJSONString((String)response);
            List versionNodes = json.get("versions").asList();
            ArrayList<T> versions = new ArrayList<T>(versionNodes.size());
            for (ModelNode node : versionNodes) {
                try {
                    versions.add(Enum.valueOf(klass, node.asString()));
                }
                catch (IllegalArgumentException e) {
                    LOGGER.warn(String.format("Unsupported server version '%s' for '%s'", node.asString(), klass.getSimpleName()));
                }
            }
            return versions;
        }
        catch (MalformedURLException e) {
            LOGGER.error("Exception", (Throwable)e);
            throw new OpenShiftException(e, "", new Object[0]);
        }
        catch (SocketTimeoutException e) {
            LOGGER.error("Exception", (Throwable)e);
            throw new OpenShiftException(e, "", new Object[0]);
        }
    }

    private Map<ResourceKind, String> getTypeMappings() {
        if (this.typeMappings.isEmpty()) {
            String osEndpoint = String.format("%s/%s", osApiEndpoint, this.getOpenShiftVersion());
            this.typeMappings.put(ResourceKind.Build, osEndpoint);
            this.typeMappings.put(ResourceKind.BuildConfig, osEndpoint);
            this.typeMappings.put(ResourceKind.DeploymentConfig, osEndpoint);
            this.typeMappings.put(ResourceKind.ImageRepository, osEndpoint);
            this.typeMappings.put(ResourceKind.Project, osEndpoint);
            this.typeMappings.put(ResourceKind.Route, osEndpoint);
            this.typeMappings.put(ResourceKind.Template, osEndpoint);
            this.typeMappings.put(ResourceKind.TemplateConfig, osEndpoint);
            String k8eEndpoint = String.format("%s/%s", apiEndpoint, this.getKubernetesVersion());
            this.typeMappings.put(ResourceKind.Pod, k8eEndpoint);
            this.typeMappings.put(ResourceKind.Service, k8eEndpoint);
            this.typeMappings.put(ResourceKind.ReplicationController, k8eEndpoint);
        }
        return this.typeMappings;
    }

    @Override
    public URL getBaseURL() {
        return this.baseUrl;
    }

    @Override
    public void setAuthorizationStrategy(IAuthorizationStrategy strategy) {
        this.client.setAuthorizationStrategy(strategy);
    }

    private com.openshift3.client.OpenShiftException handleHttpClientException(String message, HttpClientException e) {
        LOGGER.debug(message, (Throwable)e);
        if (e.getMessage().startsWith("{")) {
            return new com.openshift3.client.OpenShiftException(message, e, (IStatus)this.factory.create(e.getMessage()));
        }
        return new com.openshift3.client.OpenShiftException(message, e, null);
    }
}

