/*
 * Decompiled with CFR 0.152.
 */
package com.openshift3.internal.client;

import com.openshift3.client.IClient;
import com.openshift3.client.ResourceKind;
import com.openshift3.client.model.IResource;
import com.openshift3.internal.client.IResourceFactory;
import com.openshift3.internal.client.model.Build;
import com.openshift3.internal.client.model.BuildConfig;
import com.openshift3.internal.client.model.Config;
import com.openshift3.internal.client.model.DeploymentConfig;
import com.openshift3.internal.client.model.ImageRepository;
import com.openshift3.internal.client.model.Pod;
import com.openshift3.internal.client.model.Project;
import com.openshift3.internal.client.model.ReplicationController;
import com.openshift3.internal.client.model.Route;
import com.openshift3.internal.client.model.Service;
import com.openshift3.internal.client.model.Status;
import com.openshift3.internal.client.model.properties.ResourcePropertiesRegistry;
import com.openshift3.internal.client.model.template.Template;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.dmr.ModelNode;

public class ResourceFactory
implements IResourceFactory {
    private static final String KIND = "kind";
    private static final String APIVERSION = "apiVersion";
    private static final Map<ResourceKind, Class<? extends IResource>> IMPL_MAP = new HashMap<ResourceKind, Class<? extends IResource>>();
    private IClient client;

    public ResourceFactory(IClient client) {
        this.client = client;
    }

    @Override
    public List<IResource> createList(String json, ResourceKind kind) {
        ModelNode data = ModelNode.fromJSONString((String)json);
        String dataKind = data.get(KIND).asString();
        if (!(kind.toString() + "List").equals(dataKind)) {
            throw new RuntimeException(String.format("Unexpected container type '%s' for desired kind: %s", new Object[]{dataKind, kind}));
        }
        try {
            String version = data.get(APIVERSION).asString();
            return this.buildList(version, data.get("items").asList(), kind);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<IResource> buildList(String version, List<ModelNode> items, ResourceKind kind) throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        ArrayList<IResource> resources = new ArrayList<IResource>(items.size());
        for (ModelNode item : items) {
            resources.add((IResource)this.create(item, version, kind));
        }
        return resources;
    }

    @Override
    public <T extends IResource> T create(String response) {
        ModelNode node = ModelNode.fromJSONString((String)response);
        String version = node.get(APIVERSION).asString();
        ResourceKind kind = ResourceKind.valueOf(node.get(KIND).asString());
        return this.create(node, version, kind);
    }

    @Override
    public <T extends IResource> T create(String version, ResourceKind kind) {
        return this.create(new ModelNode(), version, kind);
    }

    private <T extends IResource> T create(ModelNode node, String version, ResourceKind kind) {
        try {
            node.get(APIVERSION).set(version);
            node.get(KIND).set(kind.toString());
            Map<String, String[]> properyKeyMap = ResourcePropertiesRegistry.getInstance().get(version, kind);
            Constructor<? extends IResource> constructor = IMPL_MAP.get((Object)kind).getConstructor(ModelNode.class, IClient.class, Map.class);
            return (T)constructor.newInstance(node, this.client, properyKeyMap);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        IMPL_MAP.put(ResourceKind.Build, Build.class);
        IMPL_MAP.put(ResourceKind.BuildConfig, BuildConfig.class);
        IMPL_MAP.put(ResourceKind.Config, Config.class);
        IMPL_MAP.put(ResourceKind.DeploymentConfig, DeploymentConfig.class);
        IMPL_MAP.put(ResourceKind.ImageRepository, ImageRepository.class);
        IMPL_MAP.put(ResourceKind.Project, Project.class);
        IMPL_MAP.put(ResourceKind.Pod, Pod.class);
        IMPL_MAP.put(ResourceKind.ReplicationController, ReplicationController.class);
        IMPL_MAP.put(ResourceKind.Route, Route.class);
        IMPL_MAP.put(ResourceKind.Status, Status.class);
        IMPL_MAP.put(ResourceKind.Service, Service.class);
        IMPL_MAP.put(ResourceKind.Template, Template.class);
    }
}

