/*
 * Decompiled with CFR 0.152.
 */
package com.openshift3.internal.client;

import com.openshift3.client.ResourceKind;
import com.openshift3.client.model.IResource;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(URLBuilder.class);
    private String baseUrl;
    private ResourceKind kind;
    private String name;
    private Map<String, String> params = new HashMap<String, String>();
    private final Map<ResourceKind, String> typeMappings;

    URLBuilder(URL baseUrl, Map<ResourceKind, String> typeMappings, IResource resource) {
        this(baseUrl, typeMappings);
        this.resource(resource);
    }

    URLBuilder(URL baseUrl, Map<ResourceKind, String> typeMappings) {
        this.baseUrl = baseUrl.toString();
        this.typeMappings = typeMappings;
    }

    URLBuilder namespace(String namespace) {
        this.addParmeter("namespace", namespace);
        return this;
    }

    URLBuilder name(String name) {
        this.name = name;
        return this;
    }

    URLBuilder kind(ResourceKind kind) {
        this.kind = kind;
        return this;
    }

    URLBuilder resource(IResource resource) {
        if (resource == null) {
            return this;
        }
        this.name = resource.getName();
        this.kind = resource.getKind();
        return this;
    }

    URLBuilder addParmeter(String key, String value) {
        this.params.put(key, value);
        return this;
    }

    URL build() {
        StringBuilder url = new StringBuilder(this.baseUrl);
        if (this.kind == null) {
            throw new RuntimeException("Unable to build a URL because the ResourceKind is unknown");
        }
        url.append("/").append(this.typeMappings.get((Object)this.kind)).append("/").append(this.kind.pluralize());
        if (this.name != null) {
            url.append("/").append(this.name);
        }
        url = this.appendParameters(url);
        try {
            LOG.debug(String.format("Built url: %s", url.toString()));
            return new URL(url.toString());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private StringBuilder appendParameters(StringBuilder url) {
        if (!this.params.isEmpty()) {
            url.append('?');
            Iterator<Map.Entry<String, String>> iterator = this.params.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                try {
                    url.append(entry.getKey()).append('=').append(URLEncoder.encode(entry.getValue(), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                if (!iterator.hasNext()) continue;
                url.append((CharSequence)url.append('&'));
            }
        }
        return url;
    }
}

