/*
 * Decompiled with CFR 0.152.
 */
package com.openshift3.internal.client.authorization;

import com.openshift.client.IHttpClient;
import com.openshift.client.NoopSSLCertificateCallback;
import com.openshift.client.OpenShiftException;
import com.openshift3.client.authorization.IAuthorizationClient;
import com.openshift3.client.authorization.IAuthorizationContext;
import com.openshift3.internal.client.authorization.AuthorizationContext;
import com.openshift3.internal.client.authorization.OpenShiftAuthorizationRedirectStrategy;
import com.openshift3.internal.util.URIUtils;
import java.io.Closeable;
import java.io.IOException;
import java.net.ProxySelector;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationClient
implements IAuthorizationClient {
    private static final Logger LOG = LoggerFactory.getLogger(IAuthorizationClient.class);
    public static final String ACCESS_TOKEN = "access_token";
    private static final String EXPIRES = "expires_in";
    private SSLContext sslContext;
    private X509HostnameVerifier hostnameVerifier = new AllowAllHostnameVerifier();

    public AuthorizationClient() {
        this.setSSLCertificateCallback(new NoopSSLCertificateCallback());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IAuthorizationContext getContext(String baseURL, String username, String password) {
        CloseableHttpResponse response = null;
        CloseableHttpClient client = null;
        try {
            OpenShiftAuthorizationRedirectStrategy redirectStrategy = new OpenShiftAuthorizationRedirectStrategy();
            client = HttpClients.custom().setRedirectStrategy((RedirectStrategy)redirectStrategy).setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner(ProxySelector.getDefault())).setDefaultCredentialsProvider(this.buildCredentialsProvider(username, password)).setHostnameVerifier(this.hostnameVerifier).setSslcontext(this.sslContext).build();
            HttpGet request = new HttpGet(new URIBuilder(String.format("%s/oauth/authorize", baseURL)).addParameter("response_type", "token").addParameter("client_id", "openshift-challenging-client").build());
            response = client.execute((HttpUriRequest)request);
            IAuthorizationContext iAuthorizationContext = this.createAuthorizationConext(response, redirectStrategy.isAuthorized());
            this.close((Closeable)response);
            this.close((Closeable)client);
            return iAuthorizationContext;
        }
        catch (URISyntaxException e) {
            try {
                throw new OpenShiftException(e, String.format("Could not authorize user %s on server at %s", username, baseURL), new Object[0]);
                catch (ClientProtocolException e2) {
                    throw new OpenShiftException(e2, String.format("Could not authorize user %s on server at %s", username, baseURL), new Object[0]);
                }
                catch (IOException e3) {
                    throw new OpenShiftException(e3, String.format("Could not authorize user %s on server at %s", username, baseURL), new Object[0]);
                }
            }
            catch (Throwable throwable) {
                this.close((Closeable)response);
                this.close((Closeable)client);
                throw throwable;
            }
        }
    }

    private IAuthorizationContext createAuthorizationConext(CloseableHttpResponse response, boolean authorized) {
        if (!authorized) {
            return new AuthorizationContext(IAuthorizationContext.AuthorizationType.Basic);
        }
        Header header = response.getFirstHeader("Location");
        Map<String, String> fragment = URIUtils.splitFragment(header.getValue());
        return new AuthorizationContext(fragment.get(ACCESS_TOKEN), fragment.get(EXPIRES));
    }

    private void close(Closeable closer) {
        if (closer == null) {
            return;
        }
        try {
            closer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private CredentialsProvider buildCredentialsProvider(String username, String password) {
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        provider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(username, password));
        return provider;
    }

    @Override
    public void setSSLCertificateCallback(IHttpClient.ISSLCertificateCallback callback) {
        X509TrustManager trustManager = null;
        if (callback != null) {
            trustManager = this.createCallbackTrustManager(callback);
        }
        try {
            this.sslContext = SSLContext.getInstance("TLS");
            this.sslContext.init(null, new TrustManager[]{trustManager}, null);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn("Could not install trust manager callback", (Throwable)e);
            this.sslContext = null;
        }
        catch (KeyManagementException e) {
            LOG.warn("Could not install trust manager callback", (Throwable)e);
            this.sslContext = null;
        }
    }

    private X509TrustManager createCallbackTrustManager(IHttpClient.ISSLCertificateCallback sslAuthorizationCallback) {
        X509TrustManager trustManager = null;
        try {
            trustManager = this.getCurrentTrustManager();
            if (trustManager == null) {
                LOG.warn("Could not install trust manager callback, no trustmanager was found.");
            } else {
                trustManager = new CallbackTrustManager(trustManager, sslAuthorizationCallback);
            }
        }
        catch (GeneralSecurityException e) {
            LOG.warn("Could not install trust manager callback.", (Throwable)e);
        }
        return trustManager;
    }

    private X509TrustManager getCurrentTrustManager() throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        X509TrustManager x509TrustManager = null;
        for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            x509TrustManager = (X509TrustManager)trustManager;
            break;
        }
        return x509TrustManager;
    }

    private static class CallbackTrustManager
    implements X509TrustManager {
        private X509TrustManager trustManager;
        private IHttpClient.ISSLCertificateCallback callback;

        private CallbackTrustManager(X509TrustManager currentTrustManager, IHttpClient.ISSLCertificateCallback callback) throws NoSuchAlgorithmException, KeyStoreException {
            this.trustManager = currentTrustManager;
            this.callback = callback;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.trustManager.getAcceptedIssuers();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            block2: {
                try {
                    this.trustManager.checkServerTrusted(chain, authType);
                }
                catch (CertificateException e) {
                    if (this.callback.allowCertificate(chain)) break block2;
                    throw e;
                }
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.trustManager.checkServerTrusted(chain, authType);
        }
    }
}

