/*
 * Decompiled with CFR 0.152.
 */
package com.openshift3.internal.client.builders;

import com.openshift3.client.images.DockerImageURI;
import com.openshift3.internal.client.builders.ImageDeploymentBuilder;
import com.openshift3.internal.client.model.BuildConfig;
import com.openshift3.internal.client.model.DeploymentConfig;
import com.openshift3.internal.client.model.ImageRepository;
import com.openshift3.internal.client.model.KubernetesResource;
import java.util.ArrayList;
import java.util.List;

public class SourceDeploymentBuilder {
    private String namespace;
    private String sourceUri;
    private DockerImageURI baseUri;
    private DockerImageURI outputUri;
    private String name;

    public SourceDeploymentBuilder(String namespace, String sourceUri, String username, DockerImageURI baseUri, String outputRepoHost) {
        this.namespace = namespace;
        this.sourceUri = sourceUri;
        this.baseUri = baseUri;
        this.name = this.getNameFromGitUrl();
        this.outputUri = new DockerImageURI(outputRepoHost, username, this.name);
    }

    public List<KubernetesResource> build() {
        ArrayList<KubernetesResource> resources = new ArrayList<KubernetesResource>();
        resources.add(this.buildBuildConfig());
        resources.add(this.buildImageRepo());
        resources.add(this.buildDeploymentConfig());
        return resources;
    }

    private ImageRepository buildImageRepo() {
        ImageRepository repo = new ImageRepository();
        repo.setName(this.name);
        repo.setNamespace(this.namespace);
        repo.setDockerImageRepository(this.outputUri);
        repo.addLabel("name", this.name);
        return repo;
    }

    private DeploymentConfig buildDeploymentConfig() {
        ImageDeploymentBuilder builder = new ImageDeploymentBuilder(this.namespace, this.outputUri, 8080);
        return (DeploymentConfig)builder.build().get(0);
    }

    private BuildConfig buildBuildConfig() {
        return null;
    }

    private String getNameFromGitUrl() {
        String[] segments = this.sourceUri.split("/");
        String repo = segments[segments.length - 1];
        if (repo.endsWith(".git")) {
            return repo.substring(0, repo.length() - 4);
        }
        return repo;
    }
}

