/*
 * Decompiled with CFR 0.152.
 */
package com.openshift3.internal.client.capability.server;

import com.openshift3.client.IClient;
import com.openshift3.client.OpenShiftException;
import com.openshift3.client.ResourceKind;
import com.openshift3.client.capability.server.IImageRegistryHosting;
import com.openshift3.client.model.IService;
import com.openshift3.client.model.IStatus;

public class DefaultImageRegistryHosting
implements IImageRegistryHosting {
    private IClient client;
    private IService service;

    public DefaultImageRegistryHosting(IClient client) {
        this.client = client;
    }

    @Override
    public String getName() {
        return "dockerImageRegistry";
    }

    @Override
    public String getRegistryUri() {
        return String.format("%s:%s", this.service.getPortalIP(), this.service.getPort());
    }

    @Override
    public boolean isSupported() {
        IStatus resource;
        try {
            resource = this.client.get(ResourceKind.Service, "docker-registry", "");
        }
        catch (OpenShiftException e) {
            resource = e.getStatus();
        }
        if (resource.getKind() == ResourceKind.Service) {
            this.service = (IService)((Object)resource);
            return true;
        }
        return false;
    }
}

