/*
 * Decompiled with CFR 0.152.
 */
package com.openshift3.internal.client.capability.server;

import com.openshift3.client.IClient;
import com.openshift3.client.ResourceKind;
import com.openshift3.client.capability.server.ITemplateProcessing;
import com.openshift3.client.model.IConfig;
import com.openshift3.client.model.IResource;
import com.openshift3.client.model.template.ITemplate;
import com.openshift3.internal.client.model.KubernetesResource;
import java.util.Collection;
import org.jboss.dmr.ModelNode;

public class ServerTemplateProcessing
implements ITemplateProcessing {
    private IClient client;

    public ServerTemplateProcessing(IClient client) {
        this.client = client;
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public IConfig process(ITemplate template, String namespace) {
        return this.client.create(new TemplateConfigAdapter(template, namespace));
    }

    protected static class TemplateConfigAdapter
    extends KubernetesResource
    implements IConfig {
        private ITemplate template;
        private String namespace;

        public TemplateConfigAdapter(ITemplate template, String namespace) {
            super(new ModelNode(), null, null);
            this.template = template;
            this.namespace = namespace;
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public ResourceKind getKind() {
            return ResourceKind.TemplateConfig;
        }

        @Override
        public String toString() {
            return this.template.toString();
        }

        @Override
        public Collection<IResource> getItems() {
            return this.template.getItems();
        }
    }
}

