/*
 * Decompiled with CFR 0.152.
 */
package com.openshift3.internal.client.model;

import com.openshift3.client.IClient;
import com.openshift3.client.images.DockerImageURI;
import com.openshift3.client.model.IBuildConfig;
import com.openshift3.client.model.build.BuildSourceType;
import com.openshift3.client.model.build.BuildStrategyType;
import com.openshift3.client.model.build.BuildTriggerType;
import com.openshift3.client.model.build.IBuildSource;
import com.openshift3.client.model.build.IBuildStrategy;
import com.openshift3.client.model.build.IBuildTrigger;
import com.openshift3.internal.client.model.KubernetesResource;
import com.openshift3.internal.client.model.build.CustomBuildStrategy;
import com.openshift3.internal.client.model.build.DockerBuildStrategy;
import com.openshift3.internal.client.model.build.GitBuildSource;
import com.openshift3.internal.client.model.build.ImageChangeTrigger;
import com.openshift3.internal.client.model.build.STIBuildStrategy;
import com.openshift3.internal.client.model.build.WebhookTrigger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class BuildConfig
extends KubernetesResource
implements IBuildConfig {
    public BuildConfig(ModelNode node, IClient client, Map<String, String[]> propertyKeys) {
        super(node, client, propertyKeys);
    }

    @Override
    public List<IBuildTrigger> getBuildTriggers() {
        ArrayList<IBuildTrigger> triggers = new ArrayList<IBuildTrigger>();
        List list = this.get("buildconfig.triggers").asList();
        String name = this.getName();
        String url = this.getClient() != null ? this.getClient().getBaseURL().toString() : "";
        String version = this.getClient() != null ? this.getClient().getOpenShiftAPIVersion() : "";
        for (ModelNode node : list) {
            switch (BuildTriggerType.valueOf(node.get("type").asString())) {
                case generic: {
                    triggers.add(new WebhookTrigger(BuildTriggerType.generic, node.get(new String[]{"generic", "secret"}).asString(), name, url, version, this.getNamespace()));
                    break;
                }
                case github: {
                    triggers.add(new WebhookTrigger(BuildTriggerType.github, node.get(new String[]{"github", "secret"}).asString(), name, url, version, this.getNamespace()));
                    break;
                }
                case imageChange: {
                    triggers.add(new ImageChangeTrigger(node.get(new String[]{"imageChange", "image"}).asString(), node.get(new String[]{"imageChange", "from", "name"}).asString(), node.get(new String[]{"imageChange", "tag"}).asString()));
                    break;
                }
            }
        }
        return triggers;
    }

    @Override
    public String getOutputRepositoryName() {
        return this.asString("buildconfig.outputrepo");
    }

    @Override
    public String getSourceURI() {
        return this.asString("buildconfig.sourceuri");
    }

    @Override
    public <T extends IBuildSource> T getBuildSource() {
        switch (BuildSourceType.valueOf(this.asString("buildconfig.source.type"))) {
            case Git: {
                return (T)new GitBuildSource(this.asString("buildconfig.sourceuri"), this.asString("buildconfig.source.ref"));
            }
        }
        return null;
    }

    public void setSource(String type, String uri) {
    }

    public void setStrategy(String type, String baseImage) {
    }

    public void setOutput(DockerImageURI imageUri) {
    }

    @Override
    public <T extends IBuildStrategy> T getBuildStrategy() {
        switch (BuildStrategyType.valueOf(this.asString("buildconfig.strategy.type"))) {
            case Custom: {
                return (T)new CustomBuildStrategy(this.asString("buildconfig.custom.image"), this.asBoolean("buildconfig.custom.exposesocket"), this.loadEnvironmentVars(new String[]{"customStrategy", "env"}, this.get("buildconfig.strategy")));
            }
            case STI: {
                return (T)new STIBuildStrategy(this.asString("buildconfig.sti.image"), this.asString("buildconfig.sti.scripts"), this.asBoolean("buildconfig.sti.clean"), this.loadEnvironmentVars(new String[]{"stiStrategy", "env"}, this.get("buildconfig.strategy")));
            }
            case Docker: {
                return (T)new DockerBuildStrategy(this.asString("buildconfig.docker.context"), this.asBoolean("buildconfig.docker.nocache"), this.asString("buildconfig.docker.baseimage"));
            }
        }
        return null;
    }

    private Map<String, String> loadEnvironmentVars(String[] key, ModelNode root) {
        HashMap<String, String> vars = new HashMap<String, String>();
        if (root.get(key).getType() == ModelType.LIST) {
            for (ModelNode env : root.get(key).asList()) {
                vars.put(env.get("name").asString(), env.get("value").asString());
            }
        }
        return vars;
    }
}

