/*
 * Decompiled with CFR 0.152.
 */
package com.openshift3.internal.client.model;

import com.openshift3.client.IClient;
import com.openshift3.client.images.DockerImageURI;
import com.openshift3.client.model.IDeploymentConfig;
import com.openshift3.internal.client.model.KubernetesResource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.dmr.ModelNode;

public class DeploymentConfig
extends KubernetesResource
implements IDeploymentConfig {
    public DeploymentConfig(ModelNode node, IClient client, Map<String, String[]> propertyKeys) {
        super(node, client, propertyKeys);
    }

    @Override
    public Map<String, String> getReplicaSelector() {
        return this.asMap("deploymentconfig.replica.selector");
    }

    public List<String> getTriggerTypes() {
        ArrayList<String> types = new ArrayList<String>();
        ModelNode triggers = this.get("deploymentconfig.triggers");
        for (ModelNode node : triggers.asList()) {
            types.add(node.get("type").asString());
        }
        return types;
    }

    public List<String> getImageNames() {
        ArrayList<String> names = new ArrayList<String>();
        List containers = this.get("deploymentconfig.containers").asList();
        for (ModelNode container : containers) {
            names.add(container.get("image").asString());
        }
        return names;
    }

    @Override
    public int getReplicas() {
        return this.asInt("deploymentconfig.replicas");
    }

    public void addContainer(DockerImageURI tag, int containerPort) {
        this.addImageChangeTrigger(tag);
        this.buildTemplate(tag, containerPort);
    }

    private void addImageChangeTrigger(DockerImageURI imageTag) {
        ModelNode triggers = this.get("deploymentconfig.triggers");
        ModelNode imageChange = new ModelNode();
        imageChange.get("type").set("ImageChange");
        ModelNode params = imageChange.get("imageChangeParams");
        params.get("automatic").set(true);
        params.get("containerNames").add(this.getName());
        params.get("repositoryName").set(imageTag.getUriWithoutTag());
        params.get("tag").set(imageTag.getTag());
        triggers.add(imageChange);
        ModelNode configChange = new ModelNode();
        configChange.get("type").set("ConfigChange");
        triggers.add(configChange);
    }

    private void buildTemplate(DockerImageURI imageTag, int containerPort) {
        ModelNode template = this.getNode().get("template");
        template.get(new String[]{"strategy", "type"}).set("Recreate");
        template.get(new String[]{"controllerTemplate", "replicas"}).set(1);
        template.get(new String[]{"controllerTemplate", "replicaSelector", "name"}).set(this.getName());
        ModelNode controllerTemplate = template.get("controllerTemplate");
        controllerTemplate.get(new String[]{"podTemplate", "desiredState", "manifest", "version"}).set(this.getApiVersion());
        ModelNode container = new ModelNode();
        container.get("name").set(imageTag.getName());
        container.get("image").set(imageTag.getAbsoluteUri());
        ModelNode port = new ModelNode();
        port.get("containerPort").set(containerPort);
        container.get("ports").add(port);
        controllerTemplate.get(new String[]{"podTemplate", "desiredState", "manifest", "containers"}).add(container);
        controllerTemplate.get(new String[]{"podTemplate", "labels", "name"}).set(imageTag.getName());
    }
}

