/*
 * Decompiled with CFR 0.152.
 */
package com.openshift3.internal.client.model;

import com.openshift3.client.IClient;
import com.openshift3.client.ResourceKind;
import com.openshift3.client.capability.CapabilityInitializer;
import com.openshift3.client.capability.CapabilityVisitor;
import com.openshift3.client.capability.ICapability;
import com.openshift3.client.model.IResource;
import com.openshift3.internal.client.model.properties.ResourcePropertyKeys;
import com.openshift3.internal.util.JBossDmrExtentions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class KubernetesResource
implements IResource,
ResourcePropertyKeys {
    private ModelNode node;
    private IClient client;
    private Map<Class<? extends ICapability>, ICapability> capabilities = new HashMap<Class<? extends ICapability>, ICapability>();
    private Map<String, String[]> propertyKeys;

    public KubernetesResource(ModelNode node, IClient client, Map<String, String[]> propertyKeys) {
        this.node = node;
        this.client = client;
        this.propertyKeys = propertyKeys;
        CapabilityInitializer.initializeCapabilities(this.capabilities, this, client);
    }

    @Override
    public <T extends ICapability> T getCapability(Class<T> capability) {
        return (T)this.capabilities.get(capability);
    }

    @Override
    public Set<Class<? extends ICapability>> getCapabilities() {
        return Collections.unmodifiableSet(this.capabilities.keySet());
    }

    @Override
    public boolean supports(Class<? extends ICapability> capability) {
        return this.capabilities.containsKey(capability);
    }

    @Override
    public <T extends ICapability> void accept(CapabilityVisitor<T> visitor) {
        if (this.capabilities.containsKey(visitor.getCapabilityType())) {
            ICapability capability = this.capabilities.get(visitor.getCapabilityType());
            visitor.visit(capability);
        }
    }

    @Override
    public Map<String, String> getAnnotations() {
        return this.asMap("annotations");
    }

    @Override
    public String getAnnotation(String key) {
        Map<String, String> annotations = this.getAnnotations();
        return annotations.get(key);
    }

    @Override
    public boolean isAnnotatedWith(String key) {
        Map<String, String> annotations = this.getAnnotations();
        return annotations.containsKey(key);
    }

    public IClient getClient() {
        return this.client;
    }

    public ModelNode getNode() {
        return this.node;
    }

    public void refresh() {
        this.node = ModelNode.fromJSONString((String)this.client.get(this.getKind(), this.getName(), this.getNamespace()).toString());
    }

    @Override
    public ResourceKind getKind() {
        if (this.node.has("kind")) {
            return ResourceKind.valueOf(this.node.get("kind").asString());
        }
        return null;
    }

    @Override
    public String getApiVersion() {
        return this.asString("apiversion");
    }

    @Override
    public String getCreationTimeStamp() {
        return this.asString("creationTimestamp");
    }

    @Override
    public String getName() {
        return this.asString("name");
    }

    @Override
    public void setName(String name) {
        this.set("name", name);
    }

    @Override
    public String getNamespace() {
        ModelNode node = this.get("namespace");
        if (node.getType() == ModelType.UNDEFINED) {
            return "";
        }
        return node.asString();
    }

    @Override
    public void setNamespace(String namespace) {
        this.set("namespace", namespace);
    }

    @Override
    public void addLabel(String key, String value) {
        ModelNode labels = this.node.get("labels");
        labels.get(key).set(value);
    }

    @Override
    public Map<String, String> getLabels() {
        return this.asMap("labels");
    }

    protected ModelNode get(String key) {
        String[] property = this.propertyKeys.get(key);
        return this.node.get(property);
    }

    protected void set(String key, int value) {
        String[] property = this.propertyKeys.get(key);
        this.node.get(property).set(value);
    }

    protected void set(String key, String value) {
        String[] property = this.propertyKeys.get(key);
        this.node.get(property).set(value);
    }

    protected Map<String, String> asMap(String property) {
        return JBossDmrExtentions.asMap(this.node, this.propertyKeys, property);
    }

    protected int asInt(String key) {
        return JBossDmrExtentions.asInt(this.node, this.propertyKeys, key);
    }

    protected String asString(String property) {
        return JBossDmrExtentions.asString(this.node, this.propertyKeys, property);
    }

    protected boolean asBoolean(String property) {
        return JBossDmrExtentions.asBoolean(this.node, this.propertyKeys, property);
    }

    public String toString() {
        return this.node.toJSONString(false);
    }

    public String toPrettyString() {
        return this.node.toJSONString(false);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.node == null ? 0 : this.node.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KubernetesResource other = (KubernetesResource)obj;
        return !(this.node == null ? other.node != null : !this.node.equals(other.node));
    }
}

