/*
 * Decompiled with CFR 0.152.
 */
package com.openshift3.internal.client.model;

import com.openshift3.client.IClient;
import com.openshift3.client.model.IReplicationController;
import com.openshift3.internal.client.model.KubernetesResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ReplicationController
extends KubernetesResource
implements IReplicationController {
    public ReplicationController(ModelNode node, IClient client, Map<String, String[]> propertyKeys) {
        super(node, client, propertyKeys);
    }

    @Override
    public int getDesiredReplicaCount() {
        return this.asInt("replicationcontroller.replicacount");
    }

    @Override
    public Map<String, String> getReplicaSelector() {
        return this.asMap("replicationcontroller.selector");
    }

    @Override
    public int getCurrentReplicaCount() {
        return this.asInt("replicationcontroller.replicacount.current");
    }

    @Override
    public Collection<String> getImages() {
        ModelNode node = this.get("replicationcontroller.containers");
        if (node.getType() != ModelType.LIST) {
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (ModelNode entry : node.asList()) {
            list.add(entry.get("image").asString());
        }
        return list;
    }
}

