/*
 * Decompiled with CFR 0.152.
 */
package com.openshift3.internal.client.model;

import com.openshift3.client.IClient;
import com.openshift3.client.ResourceKind;
import com.openshift3.client.model.IPod;
import com.openshift3.client.model.IService;
import com.openshift3.internal.client.model.KubernetesResource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.dmr.ModelNode;

public class Service
extends KubernetesResource
implements IService {
    public Service(ModelNode node, IClient client, Map<String, String[]> propertyKeys) {
        super(node, client, propertyKeys);
    }

    @Override
    public void setPort(int port) {
        this.set("service.port", port);
    }

    @Override
    public int getPort() {
        return this.asInt("service.port");
    }

    @Override
    public Map<String, String> getSelector() {
        return this.asMap("service.selector");
    }

    @Override
    public void setSelector(Map<String, String> selector) {
        ModelNode node = new ModelNode();
        for (Map.Entry<String, String> entry : selector.entrySet()) {
            node.get(entry.getKey()).set(entry.getValue());
        }
        this.get("service.selector").set(node);
    }

    @Override
    public void setSelector(String key, String value) {
        this.get("service.selector").get(key).set(value);
    }

    @Override
    public void setContainerPort(int port) {
        this.set("service.containerport", port);
    }

    @Override
    public int getContainerPort() {
        return this.asInt("service.containerport");
    }

    @Override
    public String getPortalIP() {
        return this.asString("service.portalIP");
    }

    @Override
    public List<IPod> getPods() {
        if (this.getClient() == null) {
            return new ArrayList<IPod>();
        }
        return this.getClient().list(ResourceKind.Pod, this.getNamespace(), this.getSelector());
    }
}

