/*
 * Decompiled with CFR 0.152.
 */
package com.openshift3.internal.client.model.build;

import com.openshift.internal.client.utils.StringUtils;
import com.openshift3.client.model.build.BuildTriggerType;
import com.openshift3.client.model.build.IWebhookTrigger;

public class WebhookTrigger
implements IWebhookTrigger {
    private BuildTriggerType type;
    private String secret;
    private String resourceName;
    private String baseURL;
    private String apiVersion;
    private String namespace;

    public WebhookTrigger(BuildTriggerType triggerType, String secret, String resourceName, String baseURL, String apiVersion, String namespace) {
        this.type = triggerType;
        this.secret = secret;
        this.resourceName = resourceName;
        this.baseURL = baseURL;
        this.apiVersion = apiVersion;
        this.namespace = namespace;
    }

    @Override
    public BuildTriggerType getType() {
        return this.type;
    }

    @Override
    public String getSecret() {
        return this.secret;
    }

    @Override
    public String getWebhookURL() {
        if (StringUtils.isEmpty(this.baseURL)) {
            return "";
        }
        return String.format("%s/osapi/%s/buildConfigHooks/%s/%s/%s?namespace=%s", this.baseURL, this.apiVersion, this.resourceName, this.secret, this.type.toString(), this.namespace);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.secret == null ? 0 : this.secret.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WebhookTrigger other = (WebhookTrigger)obj;
        if (this.secret == null ? other.secret != null : !this.secret.equals(other.secret)) {
            return false;
        }
        return this.type == other.type;
    }
}

