/*
 * Decompiled with CFR 0.152.
 */
package com.openshift3.internal.client.model.properties;

import com.openshift3.client.ResourceKind;
import com.openshift3.internal.client.APIModelVersion;
import com.openshift3.internal.client.KubernetesAPIVersion;
import com.openshift3.internal.client.OpenShiftAPIVersion;
import com.openshift3.internal.client.model.properties.ResourcePropertyKeys;
import java.util.HashMap;
import java.util.Map;

public final class ResourcePropertiesRegistry
implements ResourcePropertyKeys {
    private static ResourcePropertiesRegistry instance;
    private final Map<VersionKey, Map<String, String[]>> versionPropertyMap = new HashMap<VersionKey, Map<String, String[]>>();
    public static final Map<String, String[]> V1BETA1_KUBERNETES_MAP;
    public static final Map<String, String[]> V1BETA1_OPENSHIFT_MAP;

    private ResourcePropertiesRegistry() {
        this.versionPropertyMap.put(new VersionKey(KubernetesAPIVersion.v1beta1, ResourceKind.Pod), V1BETA1_KUBERNETES_MAP);
        this.versionPropertyMap.put(new VersionKey(KubernetesAPIVersion.v1beta1, ResourceKind.ReplicationController), V1BETA1_KUBERNETES_MAP);
        this.versionPropertyMap.put(new VersionKey(KubernetesAPIVersion.v1beta1, ResourceKind.Service), V1BETA1_KUBERNETES_MAP);
        this.versionPropertyMap.put(new VersionKey(KubernetesAPIVersion.v1beta1, ResourceKind.Status), V1BETA1_KUBERNETES_MAP);
        this.versionPropertyMap.put(new VersionKey(OpenShiftAPIVersion.v1beta1, ResourceKind.Build), V1BETA1_OPENSHIFT_MAP);
        this.versionPropertyMap.put(new VersionKey(OpenShiftAPIVersion.v1beta1, ResourceKind.BuildConfig), V1BETA1_OPENSHIFT_MAP);
        this.versionPropertyMap.put(new VersionKey(OpenShiftAPIVersion.v1beta1, ResourceKind.Config), V1BETA1_OPENSHIFT_MAP);
        this.versionPropertyMap.put(new VersionKey(OpenShiftAPIVersion.v1beta1, ResourceKind.DeploymentConfig), V1BETA1_OPENSHIFT_MAP);
        this.versionPropertyMap.put(new VersionKey(OpenShiftAPIVersion.v1beta1, ResourceKind.ImageRepository), V1BETA1_OPENSHIFT_MAP);
        this.versionPropertyMap.put(new VersionKey(OpenShiftAPIVersion.v1beta1, ResourceKind.Project), V1BETA1_OPENSHIFT_MAP);
        this.versionPropertyMap.put(new VersionKey(OpenShiftAPIVersion.v1beta1, ResourceKind.Route), V1BETA1_OPENSHIFT_MAP);
        this.versionPropertyMap.put(new VersionKey(OpenShiftAPIVersion.v1beta1, ResourceKind.Template), V1BETA1_OPENSHIFT_MAP);
    }

    public static final ResourcePropertiesRegistry getInstance() {
        if (instance == null) {
            instance = new ResourcePropertiesRegistry();
        }
        return instance;
    }

    public Map<String, String[]> get(String apiVersion, ResourceKind kind) {
        VersionKey key = new VersionKey(apiVersion, kind);
        if (!this.versionPropertyMap.containsKey(key)) {
            throw new RuntimeException(String.format("Version '%s' not supported for kind '%s'", new Object[]{apiVersion, kind}));
        }
        return this.versionPropertyMap.get(key);
    }

    public KubernetesAPIVersion getMaxSupportedKubernetesVersion() {
        return KubernetesAPIVersion.v1beta1;
    }

    public OpenShiftAPIVersion getMaxSupportedOpenShiftVersion() {
        return OpenShiftAPIVersion.v1beta1;
    }

    static {
        V1BETA1_KUBERNETES_MAP = new HashMap<String, String[]>(){
            {
                this.put("annotations", new String[]{"annotations"});
                this.put("apiversion", new String[]{"apiVersion"});
                this.put("creationTimestamp", new String[]{"creationTimestamp"});
                this.put("labels", new String[]{"labels"});
                this.put("name", new String[]{"id"});
                this.put("namespace", new String[]{"namespace"});
                this.put("replicationcontroller.replicacount", new String[]{"desiredState", "replicas"});
                this.put("replicationcontroller.selector", new String[]{"desiredState", "replicaSelector"});
                this.put("replicationcontroller.containers", new String[]{"desiredState", "podTemplate", "desiredState", "manifest", "containers"});
                this.put("replicationcontroller.replicacount.current", new String[]{"currentState", "replicas"});
                this.put("pod.ip", new String[]{"currentState", "podIP"});
                this.put("pod.host", new String[]{"currentState", "host"});
                this.put("pod.status", new String[]{"currentState", "status"});
                this.put("pod.containers", new String[]{"desiredState", "manifest", "containers"});
                this.put("service.containerport", new String[]{"containerPort"});
                this.put("service.port", new String[]{"port"});
                this.put("service.selector", new String[]{"selector"});
                this.put("service.portalIP", new String[]{"portalIP"});
                this.put("status.message", new String[]{"message"});
            }
        };
        V1BETA1_OPENSHIFT_MAP = new HashMap<String, String[]>(){
            {
                this.put("annotations", new String[]{"metadata", "annotations"});
                this.put("creationTimestamp", new String[]{"metadata", "creationTimestamp"});
                this.put("labels", new String[]{"metadata", "labels"});
                this.put("name", new String[]{"metadata", "name"});
                this.put("namespace", new String[]{"metadata", "namespace"});
                this.put("build.message", new String[]{"message"});
                this.put("build.podname", new String[]{"podName"});
                this.put("build.status", new String[]{"status"});
                this.put("buildconfig.source.type", new String[]{"parameters", "source", "type"});
                this.put("buildconfig.sourceuri", new String[]{"parameters", "source", "git", "uri"});
                this.put("buildconfig.source.ref", new String[]{"parameters", "source", "git", "ref"});
                this.put("buildconfig.strategy", new String[]{"parameters", "strategy"});
                this.put("buildconfig.strategy.type", new String[]{"parameters", "strategy", "type"});
                this.put("buildconfig.custom.image", new String[]{"parameters", "strategy", "customStrategy", "image"});
                this.put("buildconfig.custom.exposesocket", new String[]{"parameters", "strategy", "customStrategy", "exposeDockerSocket"});
                this.put("buildconfig.custom.env", new String[]{"parameters", "strategy", "customStrategy", "env"});
                this.put("buildconfig.docker.context", new String[]{"parameters", "strategy", "dockerStrategy", "contextDir"});
                this.put("buildconfig.docker.nocache", new String[]{"parameters", "strategy", "dockerStrategy", "noCache"});
                this.put("buildconfig.docker.baseimage", new String[]{"parameters", "strategy", "dockerStrategy", "baseImage"});
                this.put("buildconfig.outputrepo", new String[]{"parameters", "output", "to", "name"});
                this.put("buildconfig.sti.image", new String[]{"parameters", "strategy", "stiStrategy", "image"});
                this.put("buildconfig.sti.scripts", new String[]{"parameters", "strategy", "stiStrategy", "scripts"});
                this.put("buildconfig.sti.clean", new String[]{"parameters", "strategy", "stiStrategy", "clean"});
                this.put("buildconfig.sti.env", new String[]{"parameters", "strategy", "stiStrategy", "env"});
                this.put("buildconfig.triggers", new String[]{"triggers"});
                this.put("deploymentconfig.containers", new String[]{"template", "controllerTemplate", "podTemplate", "desiredState", "manifest", "containers"});
                this.put("deploymentconfig.replicas", new String[]{"template", "controllerTemplate", "replicas"});
                this.put("deploymentconfig.replica.selector", new String[]{"template", "controllerTemplate", "replicaSelector"});
                this.put("deploymentconfig.triggers", new String[]{"triggers"});
                this.put("imagerepo.dockerimagerepo", new String[]{"status", "dockerImageRepository"});
                this.put("project.displayname", new String[]{"displayName"});
                this.put("route.host", new String[]{"host"});
                this.put("route.path", new String[]{"path"});
                this.put("route.serviceName", new String[]{"serviceName"});
                this.put("route.tls.termination", new String[]{"tls", "termination"});
                this.put("route.tls.certificate", new String[]{"tls", "certificate"});
                this.put("route.tls.key", new String[]{"tls", "key"});
                this.put("route.tls.caCertificate", new String[]{"tls", "caCertificate"});
                this.put("route.tls.destinationCaCertificate", new String[]{"tls", "destinationCACertificate"});
                this.put("template.parameters", new String[]{"parameters"});
                this.put("template.items", new String[]{"items"});
            }
        };
    }

    private static class VersionKey {
        private String version;
        private ResourceKind kind;

        VersionKey(APIModelVersion version, ResourceKind kind) {
            this(version.toString(), kind);
        }

        VersionKey(String version, ResourceKind kind) {
            this.version = version.toString();
            this.kind = kind;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VersionKey other = (VersionKey)obj;
            if (this.kind == null ? other.kind != null : !this.kind.equals((Object)other.kind)) {
                return false;
            }
            return !(this.version == null ? other.version != null : !this.version.equals(other.version));
        }
    }
}

