/*
 * Decompiled with CFR 0.152.
 */
package com.openshift3.internal.client.model.template;

import com.openshift3.client.IClient;
import com.openshift3.client.model.IResource;
import com.openshift3.client.model.template.IParameter;
import com.openshift3.client.model.template.ITemplate;
import com.openshift3.internal.client.IResourceFactory;
import com.openshift3.internal.client.model.KubernetesResource;
import com.openshift3.internal.client.model.template.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.dmr.ModelNode;

public class Template
extends KubernetesResource
implements ITemplate {
    public Template(ModelNode node, IClient client, Map<String, String[]> propertyKeys) {
        super(node, client, propertyKeys);
    }

    @Override
    public Map<String, IParameter> getParameters() {
        List nodes = this.get("template.parameters").asList();
        HashMap<String, IParameter> params = new HashMap<String, IParameter>(nodes.size());
        for (ModelNode node : nodes) {
            Parameter p = new Parameter(node);
            params.put(p.getName(), p);
        }
        return params;
    }

    @Override
    public Collection<IResource> getItems() {
        List nodes = this.get("template.items").asList();
        ArrayList<IResource> resources = new ArrayList<IResource>(nodes.size());
        IResourceFactory factory = this.getClient().getResourceFactory();
        if (factory != null) {
            for (ModelNode node : nodes) {
                resources.add((IResource)factory.create(node.toJSONString(true)));
            }
        }
        return resources;
    }
}

