/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.authorization;

import com.openshift.restclient.authorization.IAuthorizationDetails;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;

public class AuthorizationDetails
implements IAuthorizationDetails {
    private static final String LINK = "Link";
    private static final String WARNING = "Warning";
    private static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final Pattern LINK_RE = Pattern.compile(".*?((?:http|https)(?::\\/{2}[\\w]+)(?:[\\/|\\.]?)(?:[^\\s\"<>]*))", 34);
    private static final Pattern WARNING_RE = Pattern.compile(".*?(\".*?\")", 34);
    private String message = "";
    private String link = "";
    private String scheme = "";

    public AuthorizationDetails(String link) {
        this.link = link;
    }

    public AuthorizationDetails(String error, String errorDetails) {
        this.message = "Unknown authorization error";
        if (error != null) {
            this.message = error;
        }
        if (errorDetails != null) {
            this.message = this.message + ": " + errorDetails;
        }
    }

    public AuthorizationDetails(Header[] headers) {
        for (Header header : headers) {
            Matcher matcher;
            String name = header.getName();
            if (LINK.equalsIgnoreCase(name)) {
                matcher = LINK_RE.matcher(header.getValue());
                if (!matcher.find()) continue;
                this.link = matcher.group(1);
                continue;
            }
            if (WARNING.equalsIgnoreCase(name)) {
                matcher = WARNING_RE.matcher(header.getValue());
                if (!matcher.find()) continue;
                this.message = matcher.group(1);
                continue;
            }
            if (!WWW_AUTHENTICATE.equalsIgnoreCase(name)) continue;
            this.scheme = header.getValue();
            if (!this.scheme.contains("realm")) continue;
            this.scheme = this.scheme.split(" ")[0];
        }
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getRequestTokenLink() {
        return this.link;
    }

    public String toString() {
        return this.message;
    }
}

