/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.capability.resources;

import com.openshift.restclient.IClient;
import com.openshift.restclient.capability.resources.IBuildTriggerable;
import com.openshift.restclient.model.IBuild;
import com.openshift.restclient.model.IBuildConfig;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.build.IBuildRequest;

public class BuildTrigger
implements IBuildTriggerable {
    private static final String BUILDCONFIG_SUBRESOURCE = "instantiate";
    private static final String BUILD_SUBRESOURCE = "clone";
    private IResource resource;
    private IClient client;
    private final String subresource;

    public BuildTrigger(IBuildConfig buildConfig, IClient client) {
        this.resource = buildConfig;
        this.client = client;
        this.subresource = BUILDCONFIG_SUBRESOURCE;
    }

    public BuildTrigger(IBuild build, IClient client) {
        this.resource = build;
        this.client = client;
        this.subresource = BUILD_SUBRESOURCE;
    }

    @Override
    public boolean isSupported() {
        return this.resource != null && this.client != null && ("Build".equals(this.resource.getKind()) || "BuildConfig".equals(this.resource.getKind()));
    }

    @Override
    public String getName() {
        return BuildTrigger.class.getSimpleName();
    }

    @Override
    public IBuild trigger() {
        IBuildRequest request = (IBuildRequest)this.client.getResourceFactory().stub("BuildRequest", this.resource.getName());
        return (IBuild)this.client.create(this.resource.getKind(), this.resource.getNamespace(), this.resource.getName(), this.subresource, request);
    }
}

