/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.capability.resources;

import com.openshift.internal.restclient.capability.resources.AbstractOpenShiftBinaryCapability;
import com.openshift.restclient.IClient;
import com.openshift.restclient.capability.resources.IPortForwardable;
import com.openshift.restclient.model.IPod;
import org.apache.commons.lang.StringUtils;

public class OpenShiftBinaryPortForwarding
extends AbstractOpenShiftBinaryCapability
implements IPortForwardable {
    private IPod pod;
    private IPortForwardable.PortPair[] pairs = new IPortForwardable.PortPair[0];

    public OpenShiftBinaryPortForwarding(IPod pod, IClient client) {
        super(client);
        this.pod = pod;
    }

    @Override
    protected void cleanup() {
        this.pairs = new IPortForwardable.PortPair[0];
    }

    @Override
    protected boolean validate() {
        return this.pairs.length != 0;
    }

    @Override
    public boolean isForwarding() {
        return this.getProcess() != null && this.getProcess().isAlive();
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public String getName() {
        return OpenShiftBinaryPortForwarding.class.getSimpleName();
    }

    @Override
    public IPortForwardable.PortPair[] getPortPairs() {
        return this.pairs;
    }

    @Override
    public synchronized void forwardPorts(IPortForwardable.PortPair ... ports) {
        this.pairs = ports;
        this.start();
    }

    @Override
    protected String[] buildArgs(String location) {
        StringBuilder args = new StringBuilder(location);
        args.append(" port-forward ").append("--insecure-skip-tls-verify=true ").append("--server=").append(this.getClient().getBaseURL()).append(" ");
        this.addToken(args).append("-n ").append(this.pod.getNamespace()).append(" ").append("-p ").append(this.pod.getName()).append(" ");
        for (IPortForwardable.PortPair pair : this.pairs) {
            args.append(pair.getLocalPort()).append(":").append(pair.getRemotePort()).append(" ");
        }
        return StringUtils.split((String)args.toString(), (String)" ");
    }
}

