/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.capability.resources;

import com.openshift.restclient.IClient;
import com.openshift.restclient.capability.resources.IProjectTemplateProcessing;
import com.openshift.restclient.capability.server.ITemplateProcessing;
import com.openshift.restclient.model.IList;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.template.ITemplate;
import java.util.Collection;

public class ProjectTemplateProcessing
implements IProjectTemplateProcessing {
    private String namespace;
    private IClient client;
    private ITemplateProcessing serverCapability;

    public ProjectTemplateProcessing(IProject project, IClient client) {
        if (client != null && client.supports(ITemplateProcessing.class)) {
            this.serverCapability = client.getCapability(ITemplateProcessing.class);
            this.client = client;
            this.namespace = project.getNamespace();
        }
    }

    @Override
    public boolean isSupported() {
        return this.serverCapability != null;
    }

    @Override
    public String getName() {
        return ProjectTemplateProcessing.class.getSimpleName();
    }

    @Override
    public ITemplate process(ITemplate template) {
        return (ITemplate)this.serverCapability.process(template, this.namespace);
    }

    @Override
    public Collection<IResource> apply(ITemplate template) {
        IList resources = (IList)this.client.getResourceFactory().create(template.getApiVersion(), "List");
        resources.addAll(template.getItems());
        return this.client.create(resources, this.namespace);
    }
}

