/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.http;

import com.openshift.internal.restclient.http.UrlConnectionHttpClient;
import com.openshift.restclient.ISSLCertificateCallback;
import com.openshift.restclient.authorization.BasicAuthorizationStrategy;
import com.openshift.restclient.authorization.IAuthorizationStrategy;
import com.openshift.restclient.http.IHttpClient;

public class UrlConnectionHttpClientBuilder {
    private String userAgent;
    private String acceptedMediaType;
    private String version;
    private Integer configTimeout;
    private ISSLCertificateCallback callback;
    private String excludeSSLCipherRegex;
    private IAuthorizationStrategy authStrategy;

    public UrlConnectionHttpClientBuilder setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public UrlConnectionHttpClientBuilder setAuthorizationStrategy(IAuthorizationStrategy strategy) {
        this.authStrategy = strategy;
        return this;
    }

    public UrlConnectionHttpClientBuilder setCredentials(String username, String password, String token) {
        return this.setAuthorizationStrategy(new BasicAuthorizationStrategy(username, password, token));
    }

    public UrlConnectionHttpClientBuilder setConfigTimeout(Integer configTimeout) {
        this.configTimeout = configTimeout;
        return this;
    }

    public UrlConnectionHttpClientBuilder setAcceptMediaType(String mediaType) {
        this.acceptedMediaType = mediaType;
        return this;
    }

    public UrlConnectionHttpClientBuilder setSSLCertificateCallback(ISSLCertificateCallback callback) {
        this.callback = callback;
        return this;
    }

    public UrlConnectionHttpClientBuilder setVersion(String version) {
        this.version = version;
        return this;
    }

    public UrlConnectionHttpClientBuilder excludeSSLCipher(String excludeSSLCipherRegex) {
        this.excludeSSLCipherRegex = excludeSSLCipherRegex;
        return this;
    }

    public IHttpClient client() {
        UrlConnectionHttpClient urlClient = new UrlConnectionHttpClient(this.userAgent, this.acceptedMediaType, this.version, this.callback, this.configTimeout, this.excludeSSLCipherRegex);
        urlClient.setAuthorizationStrategy(this.authStrategy);
        return urlClient;
    }
}

