/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.restclient.capability.resources;

import com.openshift.restclient.capability.ICapability;
import com.openshift.restclient.model.IPort;

public interface IPortForwardable
extends ICapability {
    public void forwardPorts(PortPair ... var1);

    public PortPair[] getPortPairs();

    public void stop();

    public boolean isForwarding();

    public static class PortPair {
        private int localPort = -1;
        private IPort remotePort;

        public PortPair(IPort remotePort) {
            this(remotePort.getContainerPort(), remotePort);
        }

        public PortPair(int localPort, IPort remotePort) {
            this.localPort = localPort;
            this.remotePort = remotePort;
        }

        public int getLocalPort() {
            return this.localPort;
        }

        public void setLocalPort(int port) {
            this.localPort = port;
        }

        public int getRemotePort() {
            return this.remotePort.getContainerPort();
        }

        public String getName() {
            return this.remotePort.getName();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.localPort;
            result = 31 * result + (this.remotePort == null ? 0 : this.remotePort.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PortPair other = (PortPair)obj;
            if (this.localPort != other.localPort) {
                return false;
            }
            return !(this.remotePort == null ? other.remotePort != null : !this.remotePort.equals(other.remotePort));
        }
    }
}

