/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient;

import com.openshift.internal.restclient.KubernetesAPIVersion;
import com.openshift.internal.restclient.OpenShiftAPIVersion;
import com.openshift.internal.restclient.ResourceFactory;
import com.openshift.internal.restclient.URLBuilder;
import com.openshift.internal.restclient.WatchClient;
import com.openshift.internal.restclient.capability.CapabilityInitializer;
import com.openshift.internal.restclient.http.HttpClientException;
import com.openshift.internal.restclient.http.UnauthorizedException;
import com.openshift.internal.restclient.http.UrlConnectionHttpClientBuilder;
import com.openshift.internal.restclient.model.Status;
import com.openshift.internal.restclient.model.properties.ResourcePropertiesRegistry;
import com.openshift.restclient.IClient;
import com.openshift.restclient.IOpenShiftWatchListener;
import com.openshift.restclient.IResourceFactory;
import com.openshift.restclient.ISSLCertificateCallback;
import com.openshift.restclient.IWatcher;
import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.UnsupportedOperationException;
import com.openshift.restclient.authorization.AuthorizationClientFactory;
import com.openshift.restclient.authorization.IAuthorizationClient;
import com.openshift.restclient.authorization.IAuthorizationContext;
import com.openshift.restclient.authorization.IAuthorizationDetails;
import com.openshift.restclient.authorization.IAuthorizationStrategy;
import com.openshift.restclient.authorization.ResourceForbiddenException;
import com.openshift.restclient.capability.CapabilityVisitor;
import com.openshift.restclient.capability.ICapability;
import com.openshift.restclient.http.IHttpClient;
import com.openshift.restclient.http.IHttpStatusCodes;
import com.openshift.restclient.model.IList;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.user.IUser;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jboss.dmr.ModelNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClient
implements IClient,
IHttpStatusCodes {
    public static final String SYSTEM_PROP_K8E_API_VERSION = "osjc.k8e.apiversion";
    public static final String SYSTEM_PROP_OPENSHIFT_API_VERSION = "osjc.openshift.apiversion";
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultClient.class);
    private URL baseUrl;
    private IHttpClient client;
    private IResourceFactory factory;
    private Map<Class<? extends ICapability>, ICapability> capabilities = new HashMap<Class<? extends ICapability>, ICapability>();
    private boolean capabilitiesInitialized = false;
    private static final String API_ENDPOINT = "api";
    private static final String OS_API_LEGACY_ENDPOINT = "osapi";
    private static final String OS_API_ENDPOINT = "oapi";
    private final Map<String, String> typeMappings = new HashMap<String, String>();
    private String openShiftVersion;
    private String kubernetesVersion;
    private IAuthorizationStrategy strategy;
    private IAuthorizationClient authClient;

    public DefaultClient(URL baseUrl, ISSLCertificateCallback sslCertCallback) {
        this(baseUrl, null, sslCertCallback);
    }

    DefaultClient(URL baseUrl, IHttpClient httpClient, ISSLCertificateCallback sslCertCallback) {
        this.baseUrl = baseUrl;
        this.client = httpClient != null ? httpClient : this.newIHttpClient(sslCertCallback);
        this.factory = new ResourceFactory(this);
        this.openShiftVersion = System.getProperty(SYSTEM_PROP_OPENSHIFT_API_VERSION, null);
        this.kubernetesVersion = System.getProperty(SYSTEM_PROP_K8E_API_VERSION, null);
        this.authClient = new AuthorizationClientFactory().create(this);
        this.authClient.setSSLCertificateCallback(sslCertCallback);
    }

    private IHttpClient newIHttpClient(ISSLCertificateCallback sslCertCallback) {
        return new UrlConnectionHttpClientBuilder().setAcceptMediaType("application/json").setSSLCertificateCallback(sslCertCallback).client();
    }

    @Override
    public IResourceFactory getResourceFactory() {
        return this.factory;
    }

    @Override
    public IWatcher watch(String namespace, IOpenShiftWatchListener listener, String ... kinds) {
        WatchClient watcher = new WatchClient(this.getBaseURL(), this.getTypeMappings(), this);
        return watcher.watch(Arrays.asList(kinds), namespace, listener);
    }

    @Override
    public String getResourceURI(IResource resource) {
        return new URLBuilder(this.getBaseURL(), this.getTypeMappings(), resource).build().toString();
    }

    @Override
    public <T extends IResource> List<T> list(String kind) {
        return this.list(kind, "");
    }

    @Override
    public <T extends IResource> List<T> list(String kind, String namespace) {
        return this.list(kind, namespace, new HashMap<String, String>());
    }

    @Override
    public <T extends IResource> List<T> list(String kind, String namespace, Map<String, String> labels) {
        try {
            if (!this.getTypeMappings().containsKey(kind)) {
                throw new RuntimeException("No OpenShift resource endpoint for type: " + kind);
            }
            URLBuilder builder = new URLBuilder(this.baseUrl, this.getTypeMappings()).kind(kind).namespace(namespace);
            URL endpoint = builder.build();
            String response = this.client.get(endpoint, 120000);
            LOGGER.debug(String.format("List Response: %s:", response));
            List<IResource> items = this.factory.createList(response, kind);
            return this.filterItems(items, labels);
        }
        catch (HttpClientException e) {
            throw this.createOpenShiftException(String.format("Could not list %s resources in namespace %s: %s", kind, namespace, e.getMessage()), e);
        }
        catch (SocketTimeoutException e) {
            throw new OpenShiftException((Throwable)e, "Socket timeout listing resources", new Object[0]);
        }
    }

    private <T extends IResource> List<T> filterItems(List<T> items, Map<String, String> labels) {
        if (labels.isEmpty()) {
            return items;
        }
        ArrayList<IResource> filtered = new ArrayList<IResource>();
        for (IResource item : items) {
            if (!item.getLabels().entrySet().containsAll(labels.entrySet())) continue;
            filtered.add(item);
        }
        return filtered;
    }

    @Override
    public Collection<IResource> create(IList list, String namespace) {
        ArrayList<IResource> results = new ArrayList<IResource>(list.getItems().size());
        for (IResource resource : list.getItems()) {
            try {
                results.add(this.createVersion(resource, namespace, resource.getApiVersion()));
            }
            catch (OpenShiftException e) {
                if (e.getStatus() != null) {
                    results.add(e.getStatus());
                    continue;
                }
                throw e;
            }
        }
        return results;
    }

    @Override
    public <T extends IResource> T create(T resource) {
        return this.create(resource, resource.getNamespace());
    }

    @Override
    public <T extends IResource> T create(T resource, String namespace) {
        return this.createVersion(resource, namespace, null);
    }

    private <T extends IResource> T createVersion(T resource, String namespace, String version) {
        if ("List".equals(resource.getKind())) {
            throw new UnsupportedOperationException("Generic create operation not supported for resource type 'List'");
        }
        try {
            namespace = "Project".equals(resource.getKind()) ? "" : namespace;
            URL endpoint = new URLBuilder(this.baseUrl, this.getTypeMappings()).kind(resource.getKind()).namespace(namespace).build();
            String response = this.client.post(endpoint, 120000, resource);
            LOGGER.debug(response);
            return this.factory.create(response);
        }
        catch (HttpClientException e) {
            throw this.createOpenShiftException(String.format("Could not create resource %s in namespace '%s': %s", resource.getName(), namespace, e.getMessage()), e);
        }
        catch (SocketTimeoutException e) {
            throw new OpenShiftException((Throwable)e, "Socket timeout creating resource %s", resource.getName());
        }
    }

    @Override
    public <T extends IResource> T create(String kind, String namespace, String name, String subresource, IResource payload) {
        if ("List".equals(kind)) {
            throw new UnsupportedOperationException("Generic create operation not supported for resource type 'List'");
        }
        try {
            namespace = "Project".equals(kind) ? "" : namespace;
            URL endpoint = new URLBuilder(this.baseUrl, this.getTypeMappings()).kind(kind).name(name).namespace(namespace).subresource(subresource).build();
            String response = this.client.post(endpoint, 120000, payload);
            LOGGER.debug(response);
            return this.factory.create(response);
        }
        catch (HttpClientException e) {
            throw this.createOpenShiftException(String.format("Could not create %s resource %s in namespace %s for subresource %s: %s", kind, name, namespace, subresource, e.getMessage()), e);
        }
        catch (SocketTimeoutException e) {
            throw new OpenShiftException((Throwable)e, "Socket timeout creating resource %s", name);
        }
    }

    @Override
    public <T extends IResource> T update(T resource) {
        if ("List".equals(resource.getKind())) {
            throw new UnsupportedOperationException("Update operation not supported for resource type 'List'");
        }
        try {
            URL endpoint = new URLBuilder(this.getBaseURL(), this.getTypeMappings()).resource(resource).namespace(resource.getNamespace()).build();
            String response = this.client.put(endpoint, 120000, resource);
            LOGGER.debug(response);
            return this.factory.create(response);
        }
        catch (HttpClientException e) {
            throw this.createOpenShiftException(String.format("Could not update resource %s: %s", resource.getName(), e.getMessage()), e);
        }
        catch (SocketTimeoutException e) {
            throw new OpenShiftException((Throwable)e, "Socket timeout updating resource %s", resource.getName());
        }
    }

    @Override
    public <T extends IResource> void delete(T resource) {
        if ("List".equals(resource.getKind())) {
            throw new UnsupportedOperationException("Delete operation not supported for resource type 'List'");
        }
        try {
            String namespace = "Project".equals(resource.getKind()) ? "" : resource.getNamespace();
            URL endpoint = new URLBuilder(this.baseUrl, this.getTypeMappings()).resource(resource).namespace(namespace).build();
            LOGGER.debug(String.format("Deleting resource %s", endpoint));
            String response = this.client.delete(endpoint, 120000);
            LOGGER.debug(response);
        }
        catch (HttpClientException e) {
            throw this.createOpenShiftException(String.format("Could not delete resource %s: %s", resource.getName(), e.getMessage()), e);
        }
        catch (SocketTimeoutException e) {
            throw new OpenShiftException((Throwable)e, "SocketTimeout deleting resource %s", resource.getName());
        }
    }

    @Override
    public IList get(String kind, String namespace) {
        try {
            URL endpoint = new URLBuilder(this.baseUrl, this.getTypeMappings()).kind(kind).namespace(namespace).build();
            String response = this.client.get(endpoint, 120000);
            LOGGER.debug(response);
            return (IList)this.factory.create(response);
        }
        catch (HttpClientException e) {
            throw this.createOpenShiftException(String.format("Could not list resource kind %s in namespace '%s': %s", kind, namespace, e.getMessage()), e);
        }
        catch (SocketTimeoutException e) {
            throw new OpenShiftException((Throwable)e, "SocketTimeout getting listing resource kind '%s' in namespace '%s'", kind, namespace);
        }
    }

    @Override
    public <T extends IResource> T get(String kind, String name, String namespace) {
        try {
            namespace = "Project".equals(kind) ? "" : namespace;
            URL endpoint = new URLBuilder(this.baseUrl, this.getTypeMappings()).kind(kind).name(name).namespace(namespace).build();
            String response = this.client.get(endpoint, 120000);
            LOGGER.debug(response);
            return this.factory.create(response);
        }
        catch (HttpClientException e) {
            throw this.createOpenShiftException(String.format("Could not get resource %s in namespace %s: %s", name, namespace, e.getMessage()), e);
        }
        catch (SocketTimeoutException e) {
            throw new OpenShiftException((Throwable)e, "SocketTimeout getting resource %s", name);
        }
    }

    public synchronized void initializeCapabilities() {
        if (this.capabilitiesInitialized) {
            return;
        }
        CapabilityInitializer.initializeClientCapabilities(this.capabilities, this);
        this.capabilitiesInitialized = true;
    }

    @Override
    public <T extends ICapability> T getCapability(Class<T> capability) {
        return (T)this.capabilities.get(capability);
    }

    @Override
    public boolean supports(Class<? extends ICapability> capability) {
        if (!this.capabilitiesInitialized) {
            this.initializeCapabilities();
        }
        return this.capabilities.containsKey(capability);
    }

    @Override
    public <T extends ICapability, R> R accept(CapabilityVisitor<T, R> visitor, R unsupportedCapabililityValue) {
        if (!this.capabilitiesInitialized) {
            this.initializeCapabilities();
        }
        if (this.capabilities.containsKey(visitor.getCapabilityType())) {
            ICapability capability = this.capabilities.get(visitor.getCapabilityType());
            return visitor.visit(capability);
        }
        return unsupportedCapabililityValue;
    }

    public List<KubernetesAPIVersion> getKubernetesVersions() {
        return this.getVersion(KubernetesAPIVersion.class, API_ENDPOINT);
    }

    public List<OpenShiftAPIVersion> getOpenShiftVersions() {
        List<OpenShiftAPIVersion> versions = this.getVersion(OpenShiftAPIVersion.class, OS_API_ENDPOINT);
        versions.addAll(this.getVersion(OpenShiftAPIVersion.class, OS_API_LEGACY_ENDPOINT));
        return versions;
    }

    public String getKubernetesVersion() {
        if (this.kubernetesVersion == null) {
            List<KubernetesAPIVersion> versions = this.getKubernetesVersions();
            this.kubernetesVersion = ResourcePropertiesRegistry.getInstance().getMaxSupportedKubernetesVersion(versions).toString();
        }
        return this.kubernetesVersion;
    }

    @Override
    public String getOpenShiftAPIVersion() {
        if (this.openShiftVersion == null) {
            List<OpenShiftAPIVersion> versions = this.getOpenShiftVersions();
            this.openShiftVersion = ResourcePropertiesRegistry.getInstance().getMaxSupportedOpenShiftVersion(versions).toString();
        }
        return this.openShiftVersion;
    }

    private <T extends Enum<T>> List<T> getVersion(Class<T> klass, String endpoint) {
        try {
            URL url = new URL(this.baseUrl, endpoint);
            LOGGER.debug(url.toString());
            String response = this.client.get(url, 120000);
            LOGGER.debug(response);
            ModelNode json = ModelNode.fromJSONString((String)response);
            List versionNodes = json.get("versions").asList();
            ArrayList<T> versions = new ArrayList<T>(versionNodes.size());
            for (ModelNode node : versionNodes) {
                try {
                    versions.add(Enum.valueOf(klass, node.asString()));
                }
                catch (IllegalArgumentException e) {
                    LOGGER.warn(String.format("Unsupported server version '%s' for '%s'", node.asString(), klass.getSimpleName()));
                }
            }
            return versions;
        }
        catch (MalformedURLException e) {
            LOGGER.error("Exception", (Throwable)e);
            throw new OpenShiftException((Throwable)e, "", new Object[0]);
        }
        catch (SocketTimeoutException e) {
            LOGGER.error("Exception", (Throwable)e);
            throw new OpenShiftException((Throwable)e, "", new Object[0]);
        }
        catch (HttpClientException e) {
            if (e.getResponseCode() != 403) {
                throw e;
            }
            LOGGER.error("Unauthorized exception. Can system:anonymous get the API endpoint", (Throwable)e);
            return new ArrayList();
        }
    }

    private Map<String, String> getTypeMappings() {
        return this.getTypeMappings(null);
    }

    private Map<String, String> getTypeMappings(String apiVersion) {
        if (this.typeMappings.isEmpty()) {
            String version = StringUtils.defaultIfEmpty((String)apiVersion, (String)this.getOpenShiftAPIVersion());
            String osEndpoint = String.format("%s/%s", OpenShiftAPIVersion.v1beta3.toString().equals(version) ? OS_API_LEGACY_ENDPOINT : OS_API_ENDPOINT, version);
            this.typeMappings.put("Build", osEndpoint);
            this.typeMappings.put("BuildConfig", osEndpoint);
            this.typeMappings.put("DeploymentConfig", osEndpoint);
            this.typeMappings.put("ImageStream", osEndpoint);
            this.typeMappings.put("OAuthAccessToken", osEndpoint);
            this.typeMappings.put("OAuthAuthorizeToken", osEndpoint);
            this.typeMappings.put("OAuthClient", osEndpoint);
            this.typeMappings.put("OAuthClientAuthorization", osEndpoint);
            this.typeMappings.put("Policy", osEndpoint);
            this.typeMappings.put("PolicyBinding", osEndpoint);
            this.typeMappings.put("Project", osEndpoint);
            this.typeMappings.put("ProjectRequest", osEndpoint);
            this.typeMappings.put("Role", osEndpoint);
            this.typeMappings.put("RoleBinding", osEndpoint);
            this.typeMappings.put("Route", osEndpoint);
            this.typeMappings.put("Template", osEndpoint);
            this.typeMappings.put("User", osEndpoint);
            this.typeMappings.put("TemplateConfig", osEndpoint);
            this.typeMappings.put("ProcessedTemplates", osEndpoint);
            String k8eApiVersion = StringUtils.defaultIfEmpty((String)apiVersion, (String)this.getKubernetesVersion());
            String k8eEndpoint = String.format("%s/%s", API_ENDPOINT, k8eApiVersion);
            this.typeMappings.put("Event", k8eEndpoint);
            this.typeMappings.put("Pod", k8eEndpoint);
            this.typeMappings.put("PersistentVolumeClaim", k8eEndpoint);
            this.typeMappings.put("PersistentVolume", k8eEndpoint);
            this.typeMappings.put("LimitRange", k8eEndpoint);
            this.typeMappings.put("ReplicationController", k8eEndpoint);
            this.typeMappings.put("ResourceQuota", k8eEndpoint);
            this.typeMappings.put("Service", k8eEndpoint);
            this.typeMappings.put("Secret", k8eEndpoint);
            this.typeMappings.put("ServiceAccount", k8eEndpoint);
        }
        return this.typeMappings;
    }

    @Override
    public URL getBaseURL() {
        return this.baseUrl;
    }

    @Override
    public void setAuthorizationStrategy(IAuthorizationStrategy strategy) {
        this.strategy = strategy;
        this.client.setAuthorizationStrategy(strategy);
    }

    @Override
    public IAuthorizationStrategy getAuthorizationStrategy() {
        return this.strategy;
    }

    private OpenShiftException createOpenShiftException(String message, HttpClientException e) {
        String token;
        LOGGER.debug(message, (Throwable)e);
        String string = token = this.strategy != null ? this.strategy.getToken() : "";
        if (e.getMessage() != null && e.getMessage().startsWith("{")) {
            Status status = (Status)this.factory.create(e.getMessage());
            if (status.getCode() == 403) {
                if (StringUtils.isNotBlank((String)token)) {
                    return new ResourceForbiddenException(status.getMessage(), e);
                }
                return new com.openshift.restclient.authorization.UnauthorizedException(this.authClient.getAuthorizationDetails(this.baseUrl.toString()));
            }
            return new OpenShiftException((Throwable)e, status, message, new Object[0]);
        }
        if (e instanceof UnauthorizedException) {
            return new com.openshift.restclient.authorization.UnauthorizedException(this.authClient.getAuthorizationDetails(this.baseUrl.toString()));
        }
        return new OpenShiftException((Throwable)e, message, new Object[0]);
    }

    @Override
    public IUser getCurrentUser() {
        return (IUser)this.get("User", "~", "");
    }

    @Override
    public IAuthorizationContext getContext(String baseURL) {
        return this.authClient.getContext(baseURL);
    }

    @Override
    public IAuthorizationDetails getAuthorizationDetails(String baseURL) {
        return this.authClient.getAuthorizationDetails(baseURL);
    }

    @Override
    public void setSSLCertificateCallback(ISSLCertificateCallback callback) {
        this.authClient.setSSLCertificateCallback(callback);
        this.client.setSSLCertificateCallback(callback);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.baseUrl == null ? 0 : this.baseUrl.hashCode());
        result = 31 * result + (this.kubernetesVersion == null ? 0 : this.kubernetesVersion.hashCode());
        result = 31 * result + (this.openShiftVersion == null ? 0 : this.openShiftVersion.hashCode());
        result = 31 * result + (this.strategy == null || this.strategy.getToken() == null ? 0 : this.strategy.getToken().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultClient)) {
            return false;
        }
        DefaultClient other = (DefaultClient)obj;
        if (this.baseUrl == null ? other.baseUrl != null : !this.baseUrl.equals(other.baseUrl)) {
            return false;
        }
        if (this.kubernetesVersion == null ? other.kubernetesVersion != null : !this.kubernetesVersion.equals(other.kubernetesVersion)) {
            return false;
        }
        if (this.openShiftVersion == null ? other.openShiftVersion != null : !this.openShiftVersion.equals(other.openShiftVersion)) {
            return false;
        }
        if (this.strategy == null) {
            if (other.strategy != null) {
                return false;
            }
        } else {
            String otherToken;
            String token = this.strategy.getToken();
            String string = otherToken = other.strategy == null ? null : other.strategy.getToken();
            if (token == null ? otherToken != null : !token.equals(otherToken)) {
                return false;
            }
        }
        return true;
    }
}

