/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient;

import com.openshift.internal.restclient.URLBuilder;
import com.openshift.internal.restclient.model.KubernetesResource;
import com.openshift.restclient.IClient;
import com.openshift.restclient.IOpenShiftWatchListener;
import com.openshift.restclient.IResourceFactory;
import com.openshift.restclient.IWatcher;
import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.authorization.ResourceForbiddenException;
import com.openshift.restclient.authorization.UnauthorizedException;
import com.openshift.restclient.http.IHttpStatusCodes;
import com.openshift.restclient.model.IList;
import com.openshift.restclient.model.IResource;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.UpgradeException;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchClient
implements IHttpStatusCodes,
IWatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(WatchClient.class);
    private URL baseUrl;
    private Map<String, String> typeMappings;
    private IResourceFactory factory;
    private IClient client;
    private static WebSocketClient wsClient = WatchClient.newWebSocketClient();

    public WatchClient(URL baseUrl, Map<String, String> typeMappings, IClient client) {
        this.baseUrl = baseUrl;
        this.typeMappings = typeMappings;
        this.factory = client.getResourceFactory();
        this.client = client;
    }

    public IWatcher watch(Collection<String> kinds, String namespace, IOpenShiftWatchListener listener) {
        try {
            this.start();
            ClientUpgradeRequest request = this.newRequest(this.client.getAuthorizationStrategy().getToken());
            for (String kind : kinds) {
                WatchEndpoint socket = new WatchEndpoint(listener);
                String resourceVersion = this.getResourceVersion(kind, namespace, socket);
                String endpoint = new URLBuilder(this.baseUrl, this.typeMappings).kind(kind).namespace(namespace).watch().addParmeter("resourceVersion", resourceVersion).websocket();
                this.connect(socket, endpoint, request);
            }
        }
        catch (Exception e) {
            throw this.createOpenShiftException(String.format("Could not watch resources in namespace %s: %s", namespace, e.getMessage()), e);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(WatchEndpoint socket, String endpoint, ClientUpgradeRequest request) throws Exception {
        WebSocketClient webSocketClient = wsClient;
        synchronized (webSocketClient) {
            wsClient.connect((Object)socket, new URI(endpoint), request).get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (wsClient.isStarted() || wsClient.isStarting()) {
            return;
        }
        WebSocketClient webSocketClient = wsClient;
        synchronized (webSocketClient) {
            try {
                wsClient.start();
            }
            catch (Exception e) {
                throw this.createOpenShiftException(String.format("Could not start watchClient", new Object[0]), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        try {
            WebSocketClient webSocketClient = wsClient;
            synchronized (webSocketClient) {
                if (wsClient.isStopping() || wsClient.isStopped()) {
                    return;
                }
                wsClient.stop();
            }
        }
        catch (Exception e) {
            LOGGER.debug("Unable to stop the watch client", (Throwable)e);
        }
    }

    private ClientUpgradeRequest newRequest(String token) {
        ClientUpgradeRequest request = new ClientUpgradeRequest();
        request.setHeader("Origin", this.baseUrl.toString());
        request.setHeader("User-Agent", "openshift-restclient-java");
        request.setHeader("Authorization", "Bearer " + token);
        return request;
    }

    private static WebSocketClient newWebSocketClient() {
        SslContextFactory factory = new SslContextFactory();
        factory.setTrustAll(true);
        WebSocketClient client = new WebSocketClient(factory);
        return client;
    }

    private String getResourceVersion(String kind, String namespace, WatchEndpoint endpoint) throws Exception {
        IList list = this.client.get(kind, namespace);
        Collection<IResource> items = list.getItems();
        ArrayList<IResource> resources = new ArrayList<IResource>(items.size());
        resources.addAll(items);
        endpoint.setResources(resources);
        return list.getMetadata().get("resourceVersion");
    }

    private OpenShiftException createOpenShiftException(String message, Throwable e) {
        LOGGER.debug(message, e);
        int responseCode = 0;
        if (e instanceof UpgradeException) {
            UpgradeException ex = (UpgradeException)e;
            responseCode = ex.getResponseStatusCode();
        }
        switch (responseCode) {
            case 403: {
                return new ResourceForbiddenException("Resource Forbidden", e);
            }
            case 401: {
                return new UnauthorizedException(this.client.getAuthorizationDetails(this.baseUrl.toString()));
            }
        }
        return new OpenShiftException(e, message, new Object[0]);
    }

    private class WatchEndpoint
    extends WebSocketAdapter {
        private IOpenShiftWatchListener listener;
        private List<IResource> resources;

        public WatchEndpoint(IOpenShiftWatchListener listener) {
            this.listener = listener;
        }

        public void setResources(List<IResource> resources) {
            this.resources = resources;
        }

        public void onWebSocketClose(int statusCode, String reason) {
            LOGGER.debug("WatchSocket closed");
            super.onWebSocketClose(statusCode, reason);
            this.listener.disconnected();
        }

        public void onWebSocketConnect(Session session) {
            LOGGER.debug("WatchSocket connected");
            super.onWebSocketConnect(session);
            this.listener.connected(this.resources);
        }

        public void onWebSocketError(Throwable err) {
            LOGGER.debug("WatchSocket Error", err);
            this.listener.error(WatchClient.this.createOpenShiftException("WatchSocket Error", err));
        }

        public void onWebSocketText(String message) {
            LOGGER.debug(message);
            KubernetesResource payload = (KubernetesResource)WatchClient.this.factory.create(message);
            IOpenShiftWatchListener.ChangeType event = IOpenShiftWatchListener.ChangeType.valueOf(payload.getNode().get("type").asString());
            Object resource = WatchClient.this.factory.create(payload.getNode().get("object").toJSONString(true));
            if (StringUtils.isEmpty((String)resource.getKind())) {
                LOGGER.error("Unable to determine resource kind from: " + payload.getNode().get("object").toJSONString(false));
            }
            this.listener.received((IResource)resource, event);
        }
    }
}

