/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.capability.resources;

import com.openshift.internal.restclient.capability.resources.AbstractOpenShiftBinaryCapability;
import com.openshift.restclient.IClient;
import com.openshift.restclient.capability.resources.IPodLogRetrieval;
import com.openshift.restclient.model.IPod;
import java.io.InputStream;
import java.io.SequenceInputStream;
import org.apache.commons.io.IOUtils;

public class OpenShiftBinaryPodLogRetrieval
extends AbstractOpenShiftBinaryCapability
implements IPodLogRetrieval {
    private IPod pod;
    private boolean follow;

    public OpenShiftBinaryPodLogRetrieval(IPod pod, IClient client) {
        super(client);
        this.pod = pod;
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public String getName() {
        return OpenShiftBinaryPodLogRetrieval.class.getSimpleName();
    }

    @Override
    public InputStream getLogs(boolean follow) {
        this.follow = follow;
        this.start();
        SequenceInputStream is = new SequenceInputStream(this.getProcess().getInputStream(), this.getProcess().getErrorStream());
        return is;
    }

    @Override
    protected void cleanup() {
        this.follow = false;
        if (this.getProcess() != null) {
            IOUtils.closeQuietly((InputStream)this.getProcess().getInputStream());
            IOUtils.closeQuietly((InputStream)this.getProcess().getErrorStream());
        }
    }

    @Override
    protected boolean validate() {
        return true;
    }

    @Override
    protected String buildArgs() {
        StringBuilder args = new StringBuilder();
        args.append("logs ");
        this.addSkipTlsVerify(args);
        this.addServer(args).append(" ").append(this.pod.getName()).append(" ").append("-n ").append(this.pod.getNamespace()).append(" ");
        this.addToken(args);
        if (this.follow) {
            args.append(" -f ");
        }
        return args.toString();
    }
}

