/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.capability.resources;

import com.openshift.internal.restclient.capability.resources.AbstractOpenShiftBinaryCapability;
import com.openshift.restclient.IClient;
import com.openshift.restclient.capability.resources.IPortForwardable;
import com.openshift.restclient.model.IPod;

public class OpenShiftBinaryPortForwarding
extends AbstractOpenShiftBinaryCapability
implements IPortForwardable {
    private IPod pod;
    private IPortForwardable.PortPair[] pairs = new IPortForwardable.PortPair[0];

    public OpenShiftBinaryPortForwarding(IPod pod, IClient client) {
        super(client);
        this.pod = pod;
    }

    @Override
    protected void cleanup() {
        this.pairs = new IPortForwardable.PortPair[0];
    }

    @Override
    protected boolean validate() {
        return this.pairs.length != 0;
    }

    @Override
    public boolean isForwarding() {
        return this.getProcess() != null && this.getProcess().isAlive();
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public String getName() {
        return OpenShiftBinaryPortForwarding.class.getSimpleName();
    }

    @Override
    public IPortForwardable.PortPair[] getPortPairs() {
        return this.pairs;
    }

    @Override
    public synchronized void forwardPorts(IPortForwardable.PortPair ... ports) {
        this.pairs = ports;
        this.start();
    }

    @Override
    protected String buildArgs() {
        StringBuilder args = new StringBuilder();
        args.append("port-forward ");
        this.addSkipTlsVerify(args);
        this.addServer(args);
        this.addToken(args).append("-n ").append(this.pod.getNamespace()).append(" ").append("-p ").append(this.pod.getName()).append(" ");
        for (IPortForwardable.PortPair pair : this.pairs) {
            args.append(pair.getLocalPort()).append(":").append(pair.getRemotePort()).append(" ");
        }
        return args.toString();
    }
}

