/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.capability.resources;

import com.openshift.internal.restclient.capability.resources.AbstractOpenShiftBinaryCapability;
import com.openshift.restclient.IClient;
import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.capability.resources.IRSyncable;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.eclipse.jetty.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenShiftBinaryRSync
extends AbstractOpenShiftBinaryCapability
implements IRSyncable {
    private static final Logger LOG = LoggerFactory.getLogger(OpenShiftBinaryRSync.class);
    private static final long WAIT_FOR_EXIT_TIMEOUT = 5L;
    private IRSyncable.Peer source;
    private IRSyncable.Peer destination;

    public OpenShiftBinaryRSync(IClient client) {
        super(client);
    }

    @Override
    public void sync(IRSyncable.Peer source, IRSyncable.Peer destination) throws OpenShiftException {
        this.source = source;
        this.destination = destination;
        this.start();
        this.waitForExit(source.getLocation(), destination.getLocation(), this.getProcess());
    }

    private void waitForExit(String source, String destination, Process process) {
        try {
            if (process == null) {
                throw new OpenShiftException("Could not sync %s to %s, no process was launched.", destination);
            }
            if (!process.waitFor(5L, TimeUnit.MINUTES)) {
                throw new OpenShiftException("Syncing %s to %s did not terminate within %d minutes.", source, destination, 5L);
            }
            if (process.exitValue() != 0) {
                String errorMessage = this.getErrorMessage(process.getErrorStream());
                throw new OpenShiftException("Syncing %s to %s failed" + (StringUtil.isBlank((String)errorMessage) ? "" : ":%s"), source, destination, errorMessage);
            }
        }
        catch (InterruptedException e) {
            throw new OpenShiftException((Throwable)e, "Syncing %s to %s was interrupted.", source, destination);
        }
    }

    private String getErrorMessage(InputStream errorStream) {
        try {
            return IOUtils.toString((InputStream)errorStream);
        }
        catch (IOException e) {
            LOG.error("Could not retrieve error message from process", (Throwable)e);
            return null;
        }
    }

    @Override
    protected void cleanup() {
        this.source = null;
        this.destination = null;
    }

    @Override
    protected boolean validate() {
        return this.source != null && this.destination != null && this.hasPodPeer(this.source, this.destination);
    }

    private boolean hasPodPeer(IRSyncable.Peer source, IRSyncable.Peer destination) {
        return source.isPod() || destination.isPod();
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public String getName() {
        return OpenShiftBinaryRSync.class.getSimpleName();
    }

    @Override
    protected String buildArgs() {
        StringBuilder args = new StringBuilder("rsync ");
        this.addUser(args);
        this.addToken(args);
        this.addServer(args);
        this.addSkipTlsVerify(args).append(this.source.getParameter()).append(" ").append(this.destination.getParameter());
        return args.toString();
    }
}

