/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.model;

import com.openshift.internal.restclient.capability.CapabilityInitializer;
import com.openshift.internal.restclient.model.KubernetesResource;
import com.openshift.internal.restclient.model.build.BuildStatus;
import com.openshift.internal.restclient.model.build.CustomBuildStrategy;
import com.openshift.internal.restclient.model.build.DockerBuildStrategy;
import com.openshift.internal.restclient.model.build.GitBuildSource;
import com.openshift.internal.restclient.model.build.SourceBuildStrategy;
import com.openshift.restclient.IClient;
import com.openshift.restclient.images.DockerImageURI;
import com.openshift.restclient.model.IBuild;
import com.openshift.restclient.model.build.IBuildSource;
import com.openshift.restclient.model.build.IBuildStatus;
import com.openshift.restclient.model.build.IBuildStrategy;
import java.util.Map;
import org.jboss.dmr.ModelNode;

public class Build
extends KubernetesResource
implements IBuild {
    private static final String BUILD_MESSAGE = "status.message";
    private static final String BUILD_PODNAME = "podName";
    private static final String BUILD_STATUS = "status.phase";
    private static final String BUILD_STATUS_CANCELLED = "status.cancelled";
    private static final String OUTPUT_KIND = "spec.output.to.kind";
    private static final String OUTPUT_NAME = "spec.output.to.name";
    private static final String COMPLETE = "Complete";
    private static final String FAILED = "Failed";
    private static final String CANCELLED = "Cancelled";
    private Map<String, String[]> propertyKeys;

    public Build(ModelNode node, IClient client, Map<String, String[]> propertyKeys) {
        super(node, client, propertyKeys);
        this.propertyKeys = propertyKeys;
        CapabilityInitializer.initializeCapabilities(this.getModifiableCapabilities(), this, client);
    }

    @Override
    public String getStatus() {
        return this.asString(BUILD_STATUS);
    }

    @Override
    public String getMessage() {
        return this.asString(BUILD_MESSAGE);
    }

    @Override
    public String getPodName() {
        return this.asString(BUILD_PODNAME);
    }

    @Override
    public boolean cancel() {
        String currentStatus = this.getStatus();
        if (!(currentStatus.equalsIgnoreCase(COMPLETE) || currentStatus.equalsIgnoreCase(FAILED) || currentStatus.equalsIgnoreCase(CANCELLED))) {
            this.set(BUILD_STATUS_CANCELLED, true);
            return true;
        }
        return false;
    }

    @Override
    public DockerImageURI getOutputTo() {
        return new DockerImageURI(this.asString(OUTPUT_NAME));
    }

    @Override
    public String getOutputKind() {
        return this.asString(OUTPUT_KIND);
    }

    @Override
    public <T extends IBuildSource> T getBuildSource() {
        switch (this.asString("spec.source.type")) {
            case "Git": {
                return (T)new GitBuildSource(this.asString("spec.source.git.uri"), this.asString("spec.source.git.ref"), this.asString("spec.source.git.contextDir"));
            }
        }
        return null;
    }

    @Override
    public <T extends IBuildStrategy> T getBuildStrategy() {
        switch (this.asString("spec.strategy.type")) {
            case "Custom": {
                return (T)new CustomBuildStrategy(this.asString("spec.strategy.customStrategy.image"), this.asBoolean("spec.strategy.customStrategy.exposeDockerSocket"), this.getEnvMap("spec.strategy.customStrategy.env"));
            }
            case "Source": {
                return (T)new SourceBuildStrategy(this.asString("spec.strategy.sourceStrategy.from.name"), this.asString("spec.strategy.sourceStrategy.scripts"), this.asBoolean("spec.strategy.sourceStrategy.incremental"), this.getEnvMap("spec.strategy.sourceStrategy.env"));
            }
            case "Docker": {
                return (T)new DockerBuildStrategy(this.asString("spec.strategy.dockerStrategy.contextDir"), this.asBoolean("spec.strategy.dockerStrategy.noCache"), this.asString("spec.strategy.dockerStrategy.baseImage"));
            }
        }
        return null;
    }

    @Override
    public String getPushSecret() {
        return this.asString("spec.output.pushSecret.name");
    }

    @Override
    public IBuildStatus getBuildStatus() {
        return new BuildStatus(this.get("status"), this.propertyKeys);
    }
}

