/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.model;

import com.openshift.internal.restclient.model.Container;
import com.openshift.internal.restclient.model.KubernetesResource;
import com.openshift.internal.restclient.model.Port;
import com.openshift.internal.restclient.model.volume.VolumeMount;
import com.openshift.internal.restclient.model.volume.VolumeSource;
import com.openshift.restclient.IClient;
import com.openshift.restclient.images.DockerImageURI;
import com.openshift.restclient.model.IContainer;
import com.openshift.restclient.model.IPort;
import com.openshift.restclient.model.IReplicationController;
import com.openshift.restclient.model.volume.IVolumeMount;
import com.openshift.restclient.model.volume.IVolumeSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ReplicationController
extends KubernetesResource
implements IReplicationController {
    public static final String SPEC_TEMPLATE_CONTAINERS = "spec.template.spec.containers";
    protected static final String SPEC_TEMPLATE_LABELS = "spec.template.metadata.labels";
    protected static final String VOLUMES = "spec.template.spec.volumes";
    protected static final String SPEC_REPLICAS = "spec.replicas";
    protected static final String SPEC_SELECTOR = "spec.selector";
    protected static final String STATUS_REPLICA = "status.replicas";
    protected static final String IMAGE = "image";
    protected static final String ENV = "env";

    public ReplicationController(ModelNode node, IClient client, Map<String, String[]> propertyKeys) {
        super(node, client, propertyKeys);
    }

    @Override
    public int getDesiredReplicaCount() {
        return this.asInt(SPEC_REPLICAS);
    }

    @Override
    public int getReplicas() {
        return this.getDesiredReplicaCount();
    }

    @Override
    public void setDesiredReplicaCount(int count) {
        this.set(SPEC_REPLICAS, count);
    }

    @Override
    public void setReplicas(int count) {
        this.setDesiredReplicaCount(count);
    }

    @Override
    public Map<String, String> getReplicaSelector() {
        return this.asMap(SPEC_SELECTOR);
    }

    @Override
    public void setReplicaSelector(String key, String value) {
        HashMap<String, String> selector = new HashMap<String, String>();
        selector.put(key, value);
        this.setReplicaSelector(selector);
    }

    @Override
    public void setReplicaSelector(Map<String, String> selector) {
        this.get(SPEC_SELECTOR).clear();
        this.set(SPEC_SELECTOR, selector);
    }

    @Override
    public int getCurrentReplicaCount() {
        return this.asInt(STATUS_REPLICA);
    }

    @Override
    public Collection<String> getImages() {
        ModelNode node = this.get(SPEC_TEMPLATE_CONTAINERS);
        if (node.getType() != ModelType.LIST) {
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (ModelNode entry : node.asList()) {
            list.add(entry.get(IMAGE).asString());
        }
        return list;
    }

    @Override
    public void addTemplateLabel(String key, String value) {
        ModelNode labels = this.get(SPEC_TEMPLATE_LABELS);
        labels.get(key).set(value);
    }

    @Override
    public IContainer addContainer(DockerImageURI tag, Set<IPort> containerPorts, Map<String, String> envVars) {
        return this.addContainer(tag.getName(), tag, containerPorts, envVars, new ArrayList<String>());
    }

    @Override
    public IContainer addContainer(String name, DockerImageURI tag, Set<IPort> containerPorts, Map<String, String> envVars, List<String> emptyDirVolumes) {
        IContainer container = this.addContainer(name);
        container.setImage(tag);
        if (!emptyDirVolumes.isEmpty()) {
            HashSet<IVolumeMount> volumes = new HashSet<IVolumeMount>();
            for (String path : emptyDirVolumes) {
                VolumeMount volume = new VolumeMount(new ModelNode());
                volume.setMountPath(path);
                volume.setName(String.format("%s-%s", name, emptyDirVolumes.indexOf(path) + 1));
                volumes.add(volume);
                this.addEmptyDirVolumeToPodSpec(volume);
            }
            container.setVolumeMounts(volumes);
        }
        if (!containerPorts.isEmpty()) {
            HashSet<IPort> ports = new HashSet<IPort>();
            for (IPort port : containerPorts) {
                ports.add(new Port(new ModelNode(), port));
            }
            container.setPorts(ports);
        }
        container.setEnvVars(envVars);
        return container;
    }

    private void addEmptyDirVolumeToPodSpec(VolumeMount volume) {
        ModelNode volNode = this.get(VOLUMES);
        if (volNode.isDefined()) {
            List podVolumes = volNode.asList();
            for (ModelNode node : podVolumes) {
                if (!volume.getName().equals(this.asString(node, "name"))) continue;
                return;
            }
        }
        ModelNode podVolume = volNode.add();
        this.set(podVolume, "name", volume.getName());
        this.set(podVolume, "emptyDir.medium", "");
    }

    @Override
    public IContainer addContainer(String name) {
        ModelNode containers = this.get(SPEC_TEMPLATE_CONTAINERS);
        Container container = new Container(containers.add());
        container.setName(name);
        return container;
    }

    @Override
    public Set<IVolumeSource> getVolumes() {
        ModelNode vol = this.get(VOLUMES);
        HashSet<IVolumeSource> volumes = new HashSet<IVolumeSource>();
        if (vol.isDefined()) {
            for (ModelNode node : vol.asList()) {
                volumes.add(new VolumeSource(node));
            }
        }
        return volumes;
    }
}

