/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.model.properties;

import com.openshift.internal.restclient.APIModelVersion;
import com.openshift.internal.restclient.KubernetesAPIVersion;
import com.openshift.internal.restclient.OpenShiftAPIVersion;
import com.openshift.internal.restclient.model.properties.ResourcePropertyKeys;
import com.openshift.restclient.IncompatibleApiVersionsException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResourcePropertiesRegistry
implements ResourcePropertyKeys {
    private static ResourcePropertiesRegistry instance;
    private final Map<VersionKey, Map<String, String[]>> versionPropertyMap = new HashMap<VersionKey, Map<String, String[]>>();

    private ResourcePropertiesRegistry() {
    }

    public static final ResourcePropertiesRegistry getInstance() {
        if (instance == null) {
            instance = new ResourcePropertiesRegistry();
        }
        return instance;
    }

    public Map<String, String[]> get(String apiVersion, String kind) {
        VersionKey key = new VersionKey(apiVersion, kind);
        if (!this.versionPropertyMap.containsKey(key)) {
            return new HashMap<String, String[]>();
        }
        return this.versionPropertyMap.get(key);
    }

    public KubernetesAPIVersion[] getSupportedKubernetesVersions() {
        return KubernetesAPIVersion.values();
    }

    public OpenShiftAPIVersion[] getSupportedOpenShiftVersions() {
        return OpenShiftAPIVersion.values();
    }

    public KubernetesAPIVersion getMaxSupportedKubernetesVersion(List<KubernetesAPIVersion> serverVersions) {
        return this.getMaxSupportedVersion(Arrays.asList(this.getSupportedKubernetesVersions()), serverVersions);
    }

    public OpenShiftAPIVersion getMaxSupportedOpenShiftVersion(List<OpenShiftAPIVersion> serverVersions) {
        return this.getMaxSupportedVersion(Arrays.asList(this.getSupportedOpenShiftVersions()), serverVersions);
    }

    private <T extends APIModelVersion> T getMaxSupportedVersion(List<T> clientVersions, List<T> serverVersions) {
        Collections.sort(clientVersions, new APIModelVersion.VersionComparitor());
        Collections.sort(serverVersions, new APIModelVersion.VersionComparitor());
        APIModelVersion maxClientVersion = (APIModelVersion)clientVersions.get(clientVersions.size() - 1);
        APIModelVersion maxServerVersion = (APIModelVersion)serverVersions.get(serverVersions.size() - 1);
        if (serverVersions.contains(maxClientVersion)) {
            return (T)maxClientVersion;
        }
        if (clientVersions.contains(maxServerVersion)) {
            return (T)maxServerVersion;
        }
        throw new IncompatibleApiVersionsException(clientVersions.toString(), serverVersions.toString());
    }

    private static class VersionKey {
        private String version;
        private String kind;

        VersionKey(APIModelVersion version, String kind) {
            this(version.toString(), kind);
        }

        VersionKey(String version, String kind) {
            this.version = version.toString();
            this.kind = kind;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VersionKey other = (VersionKey)obj;
            if (this.kind == null ? other.kind != null : !this.kind.equals(other.kind)) {
                return false;
            }
            return !(this.version == null ? other.version != null : !this.version.equals(other.version));
        }
    }
}

